/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.engine.Constants;
import org.h2.message.TraceSystem;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.util.IOUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;

class WebThread
extends WebApp
implements Runnable {
    protected OutputStream output;
    protected Socket socket;
    private Thread thread;
    private InputStream input;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer webServer) {
        super(webServer);
        this.socket = socket;
        this.thread = new Thread((Runnable)this, "H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int n) throws InterruptedException {
        this.thread.join(n);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String string) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (string.length() == 0) {
            return "index.do";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        boolean bl = false;
        String string = this.readHeaderLine();
        if (string.startsWith("GET ") || string.startsWith("POST ")) {
            byte[] byArray;
            String string2;
            String string3;
            int n = string.indexOf(47);
            int n2 = string.lastIndexOf(32);
            String string4 = n < 0 || n2 < n ? "" : string.substring(n + 1, n2).trim();
            this.trace(string + ": " + string4);
            string4 = this.getAllowedFile(string4);
            this.attributes = new Properties();
            int n3 = string4.indexOf("?");
            this.session = null;
            if (n3 >= 0) {
                string3 = string4.substring(n3 + 1);
                this.parseAttributes(string3);
                string2 = this.attributes.getProperty("jsessionid");
                string4 = string4.substring(0, n3);
                this.session = this.server.getSession(string2);
            }
            bl = this.parseHeader();
            string3 = this.socket.getInetAddress().getHostAddress();
            if ((string4 = this.processRequest(string4, string3)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                byArray = null;
                string2 = "HTTP/1.1 304 Not Modified\n";
            } else {
                byArray = this.server.getFile(string4);
                if (byArray == null) {
                    string2 = "HTTP/1.0 404 Not Found\n";
                    byArray = StringUtils.utf8Encode("File not found: " + string4);
                } else {
                    if (this.session != null && string4.endsWith(".jsp")) {
                        String string5 = StringUtils.utf8Decode(byArray);
                        string5 = PageParser.parse(string5, this.session.map);
                        byArray = StringUtils.utf8Encode(string5);
                    }
                    string2 = "HTTP/1.1 200 OK\n";
                    string2 = string2 + "Content-Type: " + this.mimeType + "\n";
                    if (!this.cache) {
                        string2 = string2 + "Cache-Control: no-cache\n";
                    } else {
                        string2 = string2 + "Cache-Control: max-age=10\n";
                        string2 = string2 + "Last-Modified: " + this.server.getStartDateTime() + "\n";
                    }
                    string2 = string2 + "Content-Length: " + byArray.length + "\n";
                }
            }
            string2 = string2 + "\n";
            this.trace(string2);
            this.output.write(string2.getBytes());
            if (byArray != null) {
                this.output.write(byArray);
            }
            this.output.flush();
        }
        return bl;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 13 && this.input.read() == 10 || n == 10) {
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            stringBuilder.append((char)n);
        }
    }

    private void parseAttributes(String string) {
        int n;
        this.trace("data=" + string);
        while (string != null && (n = string.indexOf(61)) >= 0) {
            String string2;
            String string3 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(38)) >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
            }
            String string4 = StringUtils.urlDecode(string2);
            this.attributes.put(string3, string4);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        Object object;
        boolean bl = false;
        this.trace("parseHeader");
        int n = 0;
        this.ifModifiedSince = null;
        block0: while ((object = this.readHeaderLine()) != null) {
            Object object2;
            this.trace(" " + (String)object);
            String string = StringUtils.toLowerEnglish((String)object);
            if (string.startsWith("if-modified-since")) {
                this.ifModifiedSince = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                continue;
            }
            if (string.startsWith("connection")) {
                object2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                if (!"keep-alive".equals(object2)) continue;
                bl = true;
                continue;
            }
            if (string.startsWith("content-length")) {
                n = Integer.parseInt(((String)object).substring(((String)object).indexOf(58) + 1).trim());
                this.trace("len=" + n);
                continue;
            }
            if (string.startsWith("accept-language")) {
                object2 = this.session == null ? null : this.session.locale;
                if (object2 != null) continue;
                String string2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("q=") || !this.server.supportsLanguage(string3)) continue;
                    int n2 = string3.indexOf(45);
                    if (n2 >= 0) {
                        String string4 = string3.substring(0, n2);
                        String string5 = string3.substring(n2 + 1);
                        object2 = new Locale(string4, string5);
                    } else {
                        object2 = new Locale(string3, "");
                    }
                    this.headerLanguage = ((Locale)object2).getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = object2;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (((String)object).trim().length() != 0) continue;
            break;
        }
        if (this.session != null && n > 0) {
            object = MemoryUtils.newBytes(n);
            for (int i = 0; i < n; i += this.input.read((byte[])object, i, n - i)) {
            }
            String string = new String((byte[])object);
            this.parseAttributes(string);
        }
        return bl;
    }

    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    protected boolean loginAsync(final String string, final String string2, final String string3, final String string4) {
        if (this.socket == null || !string2.startsWith("jdbc:h2:") || string2.startsWith("jdbc:h2:tcp:") || string2.startsWith("jdbc:h2:ssl:") || string2.startsWith("jdbc:h2:mem:")) {
            return false;
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LoginTask
            implements Runnable,
            DatabaseEventListener {
                private final PrintWriter writer;
                private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

                LoginTask() throws IOException {
                    String string5 = "HTTP/1.1 200 OK\n";
                    string5 = string5 + "Content-Type: " + WebThread.this.mimeType + "\n\n";
                    WebThread.this.output.write(string5.getBytes());
                    this.writer = new PrintWriter(WebThread.this.output);
                    this.writer.println("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\" /></head>");
                    this.writer.println("<body><h2>Opening Database</h2>URL: " + PageParser.escapeHtml(string2) + "<br />");
                    this.writer.println("User: " + PageParser.escapeHtml(string3) + "<br />");
                    this.writer.println("Version: " + Constants.getFullVersion() + "<br /><br />");
                    this.writer.flush();
                    this.log("Start...");
                }

                @Override
                public void closingDatabase() {
                    this.log("Closing database");
                }

                @Override
                public void diskSpaceIsLow(long l) {
                    this.log("No more disk space is available");
                }

                @Override
                public void exceptionThrown(SQLException sQLException, String string5) {
                    this.log("Exception: " + PageParser.escapeHtml(sQLException.toString()) + " SQL: " + PageParser.escapeHtml(string5));
                    WebThread.this.server.traceError(sQLException);
                }

                @Override
                public void init(String string5) {
                    this.log("Init: " + PageParser.escapeHtml(string5));
                }

                @Override
                public void opened() {
                    this.log("Database was opened");
                }

                @Override
                public void setProgress(int n, String string5, int n2, int n3) {
                    if (n == WebThread.this.listenerLastState) {
                        long l = System.currentTimeMillis();
                        if (l < WebThread.this.listenerLastEvent + 1000L) {
                            return;
                        }
                        WebThread.this.listenerLastEvent = l;
                    } else {
                        WebThread.this.listenerLastState = n;
                    }
                    string5 = PageParser.escapeHtml(string5);
                    switch (n) {
                        case 3: {
                            this.log("Backing up " + string5 + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 1: {
                            this.log("Creating index " + string5 + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 2: {
                            this.log("Recovering " + string5 + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 0: {
                            this.log("Scanning file " + string5 + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        default: {
                            this.log("Unknown state: " + n);
                        }
                    }
                }

                private synchronized void log(String string5) {
                    if (WebThread.this.output != null) {
                        string5 = this.dateFormat.format(new Date()) + ": " + string5;
                        this.writer.println(string5 + "<br />");
                        this.writer.flush();
                    }
                    WebThread.this.server.trace(string5);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    String string5 = (String)WebThread.this.session.get("sessionId");
                    boolean bl = string2.startsWith("jdbc:h2:");
                    try {
                        object = WebThread.this.server.getConnection(string, string2, string3, string4, this);
                        WebThread.this.session.setConnection((Connection)object);
                        WebThread.this.session.put("url", string2);
                        WebThread.this.session.put("user", string3);
                        WebThread.this.session.remove("error");
                        WebThread.this.settingSave();
                        this.log("OK<script type=\"text/javascript\">top.location=\"frame.jsp?jsessionid=" + string5 + "\"</script></body></htm>");
                    }
                    catch (Exception exception) {
                        WebThread.this.session.put("error", WebThread.this.getLoginError(exception, bl));
                        this.log("Error<script type=\"text/javascript\">top.location=\"index.jsp?jsessionid=" + string5 + "\"</script></body></html>");
                    }
                    object = this;
                    synchronized (object) {
                        IOUtils.closeSilently(WebThread.this.output);
                        try {
                            WebThread.this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        WebThread.this.output = null;
                    }
                }
            }
            LoginTask loginTask = new LoginTask();
            Thread thread = new Thread(loginTask);
            thread.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.server.traceError(unknownHostException);
            return false;
        }
    }

    private void trace(String string) {
        this.server.trace(string);
    }
}

