/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class ProcessTree {
    private static final Log LOG = LogFactory.getLog(ProcessTree.class);
    public static final long DEFAULT_SLEEPTIME_BEFORE_SIGKILL = 5000L;
    public static final boolean isSetsidAvailable = ProcessTree.isSetsidSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSetsidSupported() {
        Shell shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new Shell.ShellCommandExecutor(args);
            ((Shell.ShellCommandExecutor)shexec).execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"setsid is not available on this machine. So not using it.");
            setsidSupported = false;
            return setsidSupported;
        }
        finally {
            LOG.info((Object)("setsid exited with exit code " + shexec.getExitCode()));
            return setsidSupported;
        }
    }

    public static void destroy(String pid, long sleeptimeBeforeSigkill, boolean isProcessGroup, boolean inBackground) {
        if (isProcessGroup) {
            ProcessTree.destroyProcessGroup(pid, sleeptimeBeforeSigkill, inBackground);
        } else {
            ProcessTree.destroyProcess(pid, sleeptimeBeforeSigkill, inBackground);
        }
    }

    protected static void destroyProcess(String pid, long sleeptimeBeforeSigkill, boolean inBackground) {
        ProcessTree.terminateProcess(pid);
        ProcessTree.sigKill(pid, false, sleeptimeBeforeSigkill, inBackground);
    }

    protected static void destroyProcessGroup(String pgrpId, long sleeptimeBeforeSigkill, boolean inBackground) {
        ProcessTree.terminateProcessGroup(pgrpId);
        ProcessTree.sigKill(pgrpId, true, sleeptimeBeforeSigkill, inBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateProcess(String pid) {
        Shell shexec = null;
        try {
            String[] args = new String[]{"kill", pid};
            shexec = new Shell.ShellCommandExecutor(args);
            ((Shell.ShellCommandExecutor)shexec).execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + ioe));
        }
        finally {
            LOG.info((Object)("Killing process " + pid + " with SIGTERM. Exit code " + shexec.getExitCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateProcessGroup(String pgrpId) {
        Shell shexec = null;
        try {
            String[] args = new String[]{"kill", "--", "-" + pgrpId};
            shexec = new Shell.ShellCommandExecutor(args);
            ((Shell.ShellCommandExecutor)shexec).execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + ioe));
        }
        finally {
            LOG.info((Object)("Killing all processes in the process group " + pgrpId + " with SIGTERM. Exit code " + shexec.getExitCode()));
        }
    }

    private static void sigKillInCurrentThread(String pid, boolean isProcessGroup, long sleepTimeBeforeSigKill) {
        if (isProcessGroup || ProcessTree.isAlive(pid)) {
            try {
                Thread.sleep(sleepTimeBeforeSigKill);
            }
            catch (InterruptedException i) {
                LOG.warn((Object)"Thread sleep is interrupted.");
            }
            if (isProcessGroup) {
                ProcessTree.killProcessGroup(pid);
            } else {
                ProcessTree.killProcess(pid);
            }
        }
    }

    private static void sigKill(String pid, boolean isProcessGroup, long sleeptimeBeforeSigkill, boolean inBackground) {
        if (inBackground) {
            SigKillThread sigKillThread = new SigKillThread(pid, isProcessGroup, sleeptimeBeforeSigkill);
            sigKillThread.setDaemon(true);
            sigKillThread.start();
        } else {
            ProcessTree.sigKillInCurrentThread(pid, isProcessGroup, sleeptimeBeforeSigkill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcess(String pid) {
        if (!ProcessTree.isAlive(pid)) {
            return;
        }
        String[] args = new String[]{"kill", "-9", pid};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args);
        try {
            shexec.execute();
        }
        catch (IOException e) {
            LOG.warn((Object)("Error sending SIGKILL to process " + pid + " ." + StringUtils.stringifyException(e)));
        }
        finally {
            LOG.info((Object)("Killing process " + pid + " with SIGKILL. Exit code " + shexec.getExitCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcessGroup(String pgrpId) {
        if (!ProcessTree.isProcessGroupAlive(pgrpId)) {
            return;
        }
        String[] args = new String[]{"kill", "-9", "-" + pgrpId};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args);
        try {
            shexec.execute();
        }
        catch (IOException e) {
            LOG.warn((Object)("Error sending SIGKILL to process group " + pgrpId + " ." + StringUtils.stringifyException(e)));
        }
        finally {
            LOG.info((Object)("Killing process group" + pgrpId + " with SIGKILL. Exit code " + shexec.getExitCode()));
        }
    }

    public static boolean isAlive(String pid) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", pid};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe));
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    public static boolean isProcessGroupAlive(String pgrpId) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", "-" + pgrpId};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe));
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    static class SigKillThread
    extends Thread {
        private String pid = null;
        private boolean isProcessGroup = false;
        private long sleepTimeBeforeSigKill = 5000L;

        private SigKillThread(String pid, boolean isProcessGroup, long interval) {
            this.pid = pid;
            this.isProcessGroup = isProcessGroup;
            this.setName(this.getClass().getName() + "-" + pid);
            this.sleepTimeBeforeSigKill = interval;
        }

        @Override
        public void run() {
            ProcessTree.sigKillInCurrentThread(this.pid, this.isProcessGroup, this.sleepTimeBeforeSigKill);
        }
    }
}

