/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class CombineFileRecordReader<K, V>
implements RecordReader<K, V> {
    static final Class[] constructorSignature = new Class[]{CombineFileSplit.class, Configuration.class, Reporter.class, Integer.class};
    protected CombineFileSplit split;
    protected JobConf jc;
    protected Reporter reporter;
    protected Class<RecordReader<K, V>> rrClass;
    protected Constructor<RecordReader<K, V>> rrConstructor;
    protected FileSystem fs;
    protected int idx;
    protected long progress;
    protected RecordReader<K, V> curReader;

    @Override
    public boolean next(K key, V value) throws IOException {
        while (this.curReader == null || !this.curReader.next(key, value)) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        return true;
    }

    @Override
    public K createKey() {
        return this.curReader.createKey();
    }

    @Override
    public V createValue() {
        return this.curReader.createValue();
    }

    @Override
    public long getPos() throws IOException {
        return this.progress;
    }

    @Override
    public void close() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
    }

    @Override
    public float getProgress() throws IOException {
        long subprogress = 0L;
        if (null != this.curReader) {
            subprogress = (long)(this.curReader.getProgress() * (float)this.split.getLength(this.idx - 1));
        }
        return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
    }

    public CombineFileRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
        this.split = split;
        this.jc = job;
        this.rrClass = rrClass;
        this.reporter = reporter;
        this.idx = 0;
        this.curReader = null;
        this.progress = 0L;
        try {
            this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
            this.rrConstructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
        }
        this.initNextRecordReader();
    }

    protected boolean initNextRecordReader() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
            if (this.idx > 0) {
                this.progress += this.split.getLength(this.idx - 1);
            }
        }
        if (this.idx == this.split.getNumPaths()) {
            return false;
        }
        try {
            this.curReader = this.rrConstructor.newInstance(this.split, this.jc, this.reporter, this.idx);
            this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
            this.jc.setLong("map.input.start", this.split.getOffset(this.idx));
            this.jc.setLong("map.input.length", this.split.getLength(this.idx));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.idx;
        return true;
    }
}

