/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;

public class Filters
implements PlugInFilter {
    private static double sd = Prefs.getDouble("noise.sd", 25.0);
    private String arg;
    private ImagePlus imp;
    private int slice;
    private boolean canceled;

    public int setup(String string, ImagePlus imagePlus) {
        int n;
        Roi roi;
        this.arg = string;
        this.imp = imagePlus;
        if (imagePlus != null && (roi = imagePlus.getRoi()) != null && !roi.isArea()) {
            imagePlus.killRoi();
        }
        if (((n = IJ.setupDialog(imagePlus, 93)) & 0x20) != 0 && imagePlus.getType() == 1 && imagePlus.getStackSize() > 1 && string.equals("invert")) {
            this.invert16BitStack(imagePlus);
            return 4096;
        }
        return n;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.arg.equals("invert")) {
            imageProcessor.invert();
            return;
        }
        if (this.arg.equals("smooth")) {
            imageProcessor.setSnapshotCopyMode(true);
            imageProcessor.smooth();
            imageProcessor.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("sharpen")) {
            imageProcessor.setSnapshotCopyMode(true);
            imageProcessor.sharpen();
            imageProcessor.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("edge")) {
            imageProcessor.setSnapshotCopyMode(true);
            imageProcessor.findEdges();
            imageProcessor.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("add")) {
            imageProcessor.noise(25.0);
            return;
        }
        if (this.arg.equals("noise")) {
            if (this.canceled) {
                return;
            }
            ++this.slice;
            if (this.slice == 1) {
                GenericDialog genericDialog = new GenericDialog("Gaussian Noise");
                genericDialog.addNumericField("Standard Deviation:", sd, 2);
                genericDialog.showDialog();
                if (genericDialog.wasCanceled()) {
                    this.canceled = true;
                    return;
                }
                sd = genericDialog.getNextNumber();
            }
            imageProcessor.noise(sd);
            IJ.register(Filters.class);
            return;
        }
    }

    void invert16BitStack(ImagePlus imagePlus) {
        imagePlus.killRoi();
        imagePlus.getCalibration().disableDensityCalibration();
        StackStatistics stackStatistics = new StackStatistics(imagePlus);
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        int n2 = (int)stackStatistics.min;
        int n3 = (int)(stackStatistics.max - stackStatistics.min);
        int n4 = imagePlus.getWidth() * imagePlus.getHeight();
        for (int i = 1; i <= n; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            short[] sArray = (short[])imageProcessor.getPixels();
            for (int j = 0; j < n4; ++j) {
                int n5 = sArray[j] & 0xFFFF;
                sArray[j] = (short)(n3 - ((sArray[j] & 0xFFFF) - n2));
            }
        }
        imagePlus.setStack(null, imageStack);
        imagePlus.setDisplayRange(0.0, n3);
        imagePlus.updateAndDraw();
    }

    public static double getSD() {
        return sd;
    }
}

