/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.plugin.filter.Convolver;
import ij.process.DownsizeTable;
import ij.process.FloatBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class FloatProcessor
extends ImageProcessor {
    private float min;
    private float max;
    private float snapshotMin;
    private float snapshotMax;
    private float[] pixels;
    protected byte[] pixels8;
    private float[] snapshotPixels = null;
    private float fillColor = Float.MAX_VALUE;
    private boolean fixedScale = false;

    public FloatProcessor(int n, int n2, float[] fArray, ColorModel colorModel) {
        if (fArray != null && n * n2 != fArray.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = n;
        this.height = n2;
        this.pixels = fArray;
        this.cm = colorModel;
        this.resetRoi();
    }

    public FloatProcessor(int n, int n2) {
        this(n, n2, new float[n * n2], null);
    }

    public FloatProcessor(int n, int n2, int[] nArray) {
        this(n, n2);
        for (int i = 0; i < nArray.length; ++i) {
            this.pixels[i] = nArray[i];
        }
    }

    public FloatProcessor(int n, int n2, double[] dArray) {
        this(n, n2);
        for (int i = 0; i < dArray.length; ++i) {
            this.pixels[i] = (float)dArray[i];
        }
    }

    public FloatProcessor(float[][] fArray) {
        this.width = fArray.length;
        this.height = fArray[0].length;
        this.pixels = new float[this.width * this.height];
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pixels[n++] = fArray[j][i];
            }
        }
        this.resetRoi();
    }

    public FloatProcessor(int[][] nArray) {
        this.width = nArray.length;
        this.height = nArray[0].length;
        this.pixels = new float[this.width * this.height];
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pixels[n++] = nArray[j][i];
            }
        }
    }

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        for (int i = 0; i < this.width * this.height; ++i) {
            float f = this.pixels[i];
            if (Float.isInfinite(f)) continue;
            if (f < this.min) {
                this.min = f;
            }
            if (!(f > this.max)) continue;
            this.max = f;
        }
        this.minMaxSet = true;
        this.showProgress(1.0);
    }

    public void setMinAndMax(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.resetMinAndMax();
            return;
        }
        this.min = (float)d;
        this.max = (float)d2;
        this.fixedScale = true;
        this.minMaxSet = true;
        this.resetThreshold();
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.resetThreshold();
    }

    public double getMin() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public Image createImage() {
        boolean bl;
        boolean bl2 = bl = this.pixels8 == null;
        if (bl || !this.lutAnimation) {
            this.create8BitImage();
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels8, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        this.lutAnimation = false;
        return this.img;
    }

    protected byte[] create8BitImage() {
        int n = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[n];
        }
        float f = (float)this.getMin();
        float f2 = (float)this.getMax();
        float f3 = 255.0f / (f2 - f);
        for (int i = 0; i < n; ++i) {
            int n2;
            float f4 = this.pixels[i] - f;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if ((n2 = (int)(f4 * f3 + 0.5f)) > 255) {
                n2 = 255;
            }
            this.pixels8[i] = (byte)n2;
        }
        return this.pixels8;
    }

    public BufferedImage getBufferedImage() {
        return this.convertToByte(true).getBufferedImage();
    }

    public ImageProcessor createProcessor(int n, int n2) {
        FloatProcessor floatProcessor = new FloatProcessor(n, n2, new float[n * n2], this.getColorModel());
        ((ImageProcessor)floatProcessor).setMinAndMax(this.getMin(), this.getMax());
        floatProcessor.setInterpolationMethod(this.interpolationMethod);
        return floatProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = (float)this.getMin();
        this.snapshotMax = (float)this.getMax();
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new float[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        this.minMaxSet = true;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor imageProcessor) {
        if (imageProcessor == null || this.snapshotPixels == null) {
            return;
        }
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] == 0) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
    }

    public void setSnapshotPixels(Object object) {
        this.snapshotPixels = (float[])object;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return Float.floatToIntBits(this.pixels[n2 * this.width + n]);
        }
        return 0;
    }

    public final int get(int n, int n2) {
        return Float.floatToIntBits(this.pixels[n2 * this.width + n]);
    }

    public final void set(int n, int n2, int n3) {
        this.pixels[n2 * this.width + n] = Float.intBitsToFloat(n3);
    }

    public final int get(int n) {
        return Float.floatToIntBits(this.pixels[n]);
    }

    public final void set(int n, int n2) {
        this.pixels[n] = Float.intBitsToFloat(n2);
    }

    public final float getf(int n, int n2) {
        return this.pixels[n2 * this.width + n];
    }

    public final void setf(int n, int n2, float f) {
        this.pixels[n2 * this.width + n] = f;
    }

    public final float getf(int n) {
        return this.pixels[n];
    }

    public final void setf(int n, float f) {
        this.pixels[n] = f;
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{(int)this.getPixelValue(n, n2)};
        }
        return nArray;
    }

    public final void putPixel(int n, int n2, int[] nArray) {
        this.putPixelValue(n, n2, nArray[0]);
    }

    public double getInterpolatedPixel(double d, double d2) {
        if (this.interpolationMethod == 2) {
            return this.getBicubicInterpolatedPixel(d, d2, this);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    public final int getPixelInterpolated(double d, double d2) {
        if (this.interpolationMethod == 1) {
            if (d < 0.0 || d2 < 0.0 || d >= (double)(this.width - 1) || d2 >= (double)(this.height - 1)) {
                return 0;
            }
            return Float.floatToIntBits((float)this.getInterpolatedPixel(d, d2, this.pixels));
        }
        if (this.interpolationMethod == 2) {
            return Float.floatToIntBits((float)this.getBicubicInterpolatedPixel(d, d2, this));
        }
        return this.getPixel((int)(d + 0.5), (int)(d2 + 0.5));
    }

    public final void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = Float.intBitsToFloat(n3);
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = (float)d;
        }
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n];
        }
        return 0.0f;
    }

    public void drawPixel(int n, int n2) {
        if (n >= this.clipXMin && n <= this.clipXMax && n2 >= this.clipYMin && n2 <= this.clipYMax) {
            this.putPixel(n, n2, Float.floatToIntBits(this.fillColor));
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.snapshotCopyMode && this.snapshotPixels != null) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        float[] fArray = new float[this.width * this.height];
        System.arraycopy(this.pixels, 0, fArray, 0, this.width * this.height);
        return fArray;
    }

    public void setPixels(Object object) {
        this.pixels = (float[])object;
        this.resetPixels(object);
        if (object == null) {
            this.snapshotPixels = null;
        }
        if (object == null) {
            this.pixels8 = null;
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        imageProcessor = imageProcessor.convertToFloat();
        new FloatBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
    }

    private void process(int n, double d) {
        float f = (float)d;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (n == 0) {
            f2 = (float)this.getMin();
            f3 = (float)this.getMax();
        }
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n2 = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                float f4;
                float f5 = this.pixels[n2];
                switch (n) {
                    case 0: {
                        f4 = f3 - (f5 - f2);
                        break;
                    }
                    case 1: {
                        f4 = this.fillColor;
                        break;
                    }
                    case 2: {
                        f4 = f5 + f;
                        break;
                    }
                    case 3: {
                        f4 = f5 * f;
                        break;
                    }
                    case 7: {
                        if (f5 <= 0.0f) {
                            f4 = 0.0f;
                            break;
                        }
                        f4 = (float)Math.exp((double)f * Math.log(f5));
                        break;
                    }
                    case 8: {
                        if (f5 <= 0.0f) {
                            f4 = 0.0f;
                            break;
                        }
                        f4 = (float)Math.log(f5);
                        break;
                    }
                    case 13: {
                        f4 = (float)Math.exp(f5);
                        break;
                    }
                    case 11: {
                        f4 = f5 * f5;
                        break;
                    }
                    case 12: {
                        if (f5 <= 0.0f) {
                            f4 = 0.0f;
                            break;
                        }
                        f4 = (float)Math.sqrt(f5);
                        break;
                    }
                    case 14: {
                        f4 = Math.abs(f5);
                        break;
                    }
                    case 9: {
                        if ((double)f5 < d) {
                            f4 = (float)d;
                            break;
                        }
                        f4 = f5;
                        break;
                    }
                    case 10: {
                        if ((double)f5 > d) {
                            f4 = (float)d;
                            break;
                        }
                        f4 = f5;
                        break;
                    }
                    default: {
                        f4 = f5;
                    }
                }
                this.pixels[n2++] = f4;
            }
        }
    }

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void add(double d) {
        this.process(2, d);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
    }

    public void or(int n) {
    }

    public void xor(int n) {
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void exp() {
        this.process(13, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void abs() {
        this.process(14, 0.0);
    }

    public void min(double d) {
        this.process(9, d);
    }

    public void max(double d) {
        this.process(10, d);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(ImageProcessor imageProcessor) {
        if (imageProcessor == null) {
            this.fill();
            return;
        }
        int n = this.roiWidth;
        int n2 = this.roiHeight;
        int n3 = this.roiX;
        int n4 = this.roiY;
        if (imageProcessor.getWidth() != n || imageProcessor.getHeight() != n2) {
            return;
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = n4;
        int n6 = 0;
        while (n5 < n4 + n2) {
            int n7 = n5 * this.width + n3;
            int n8 = n6 * n;
            for (int i = n3; i < n3 + n; ++i) {
                if (byArray[n8++] != 0) {
                    this.pixels[n7] = this.fillColor;
                }
                ++n7;
            }
            ++n5;
            ++n6;
        }
    }

    public void convolve3x3(int[] nArray) {
        this.filter3x3(5, nArray);
    }

    public void filter(int n) {
        this.filter3x3(n, null);
    }

    void filter3x3(int n, int[] nArray) {
        int n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (n == 5) {
            f = nArray[0];
            f2 = nArray[1];
            f3 = nArray[2];
            f4 = nArray[3];
            f5 = nArray[4];
            f6 = nArray[5];
            f7 = nArray[6];
            f8 = nArray[7];
            f9 = nArray[8];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                f10 += (float)nArray[n2];
            }
            if (f10 == 0.0f) {
                f10 = 1.0f;
            }
            f10 = 1.0f / f10;
        }
        if ((n2 = this.roiHeight / 25) < 1) {
            n2 = 1;
        }
        float[] fArray = (float[])this.getPixelsCopy();
        int n3 = this.roiX + this.roiWidth;
        int n4 = this.roiY + this.roiHeight;
        for (int i = this.roiY; i < n4; ++i) {
            int n5 = this.roiX + i * this.width;
            int n6 = n5 - (this.roiX > 0 ? 1 : 0);
            int n7 = n6 - (i > 0 ? this.width : 0);
            int n8 = n6 + (i < this.height - 1 ? this.width : 0);
            float f11 = fArray[n7];
            float f12 = fArray[n6];
            float f13 = fArray[n8];
            if (this.roiX > 0) {
                ++n7;
                ++n6;
                ++n8;
            }
            float f14 = fArray[n7];
            float f15 = fArray[n6];
            float f16 = fArray[n8];
            switch (n) {
                case 0: {
                    float f17;
                    float f18;
                    float f19;
                    int n9 = this.roiX;
                    while (n9 < n3) {
                        if (n9 < this.width - 1) {
                            ++n7;
                            ++n6;
                            ++n8;
                        }
                        f19 = f11;
                        f11 = f14;
                        f14 = fArray[n7];
                        f18 = f12;
                        f12 = f15;
                        f15 = fArray[n6];
                        f17 = f13;
                        f13 = f16;
                        f16 = fArray[n8];
                        this.pixels[n5] = (f19 + f11 + f14 + f18 + f12 + f15 + f17 + f13 + f16) * 0.11111111f;
                        ++n9;
                        ++n5;
                    }
                    break;
                }
                case 1: {
                    float f20;
                    float f17;
                    float f18;
                    float f19;
                    int n9 = this.roiX;
                    while (n9 < n3) {
                        if (n9 < this.width - 1) {
                            ++n7;
                            ++n6;
                            ++n8;
                        }
                        f19 = f11;
                        f11 = f14;
                        f14 = fArray[n7];
                        f18 = f12;
                        f12 = f15;
                        f15 = fArray[n6];
                        f17 = f13;
                        f13 = f16;
                        f16 = fArray[n8];
                        f20 = f19 + 2.0f * f11 + f14 - f17 - 2.0f * f13 - f16;
                        float f21 = f19 + 2.0f * f18 + f17 - f14 - 2.0f * f15 - f16;
                        this.pixels[n5] = (float)Math.sqrt(f20 * f20 + f21 * f21);
                        ++n9;
                        ++n5;
                    }
                    break;
                }
                case 5: {
                    float f20;
                    float f17;
                    float f18;
                    float f19;
                    int n9 = this.roiX;
                    while (n9 < n3) {
                        if (n9 < this.width - 1) {
                            ++n7;
                            ++n6;
                            ++n8;
                        }
                        f19 = f11;
                        f11 = f14;
                        f14 = fArray[n7];
                        f18 = f12;
                        f12 = f15;
                        f15 = fArray[n6];
                        f17 = f13;
                        f13 = f16;
                        f16 = fArray[n8];
                        f20 = f * f19 + f2 * f11 + f3 * f14 + f4 * f18 + f5 * f12 + f6 * f15 + f7 * f17 + f8 * f13 + f9 * f16;
                        this.pixels[n5] = f20 *= f10;
                        ++n9;
                        ++n5;
                    }
                    break;
                }
            }
            if (i % n2 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void rotate(double d) {
        float[] fArray = (float[])this.getPixelsCopy();
        FloatProcessor floatProcessor = null;
        if (this.interpolationMethod == 2) {
            floatProcessor = new FloatProcessor(this.getWidth(), this.getHeight(), fArray, null);
        }
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        if (this.interpolationMethod == 2) {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n2 = i * this.width + this.roiX;
                double d9 = d7 - (double)i * d6 + d2;
                double d10 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n; ++j) {
                    double d11 = (double)j * d5 + d9;
                    double d12 = (double)j * d6 + d10;
                    this.pixels[n2++] = (float)this.getBicubicInterpolatedPixel(d11, d12, floatProcessor);
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        } else {
            double d13 = this.width;
            double d14 = this.height;
            double d15 = (double)this.width - 1.0;
            double d16 = (double)this.width - 1.001;
            double d17 = (double)this.height - 1.0;
            double d18 = (double)this.height - 1.001;
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n3 = i * this.width + this.roiX;
                double d19 = d7 - (double)i * d6 + d2;
                double d20 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n; ++j) {
                    double d21 = (double)j * d5 + d19;
                    double d22 = (double)j * d6 + d20;
                    if (d21 >= -0.01 && d21 < d13 && d22 >= -0.01 && d22 < d14) {
                        if (this.interpolationMethod == 1) {
                            if (d21 < 0.0) {
                                d21 = 0.0;
                            }
                            if (d21 >= d15) {
                                d21 = d16;
                            }
                            if (d22 < 0.0) {
                                d22 = 0.0;
                            }
                            if (d22 >= d17) {
                                d22 = d18;
                            }
                            this.pixels[n3++] = (float)this.getInterpolatedPixel(d21, d22, fArray);
                            continue;
                        }
                        int n4 = (int)(d21 + 0.5);
                        int n5 = (int)(d22 + 0.5);
                        if (n4 >= this.width) {
                            n4 = this.width - 1;
                        }
                        if (n5 >= this.height) {
                            n5 = this.height - 1;
                        }
                        this.pixels[n3++] = fArray[this.width * n5 + n4];
                        continue;
                    }
                    this.pixels[n3++] = 0.0f;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        }
        this.showProgress(1.0);
    }

    public void flipVertical() {
        for (int i = 0; i < this.roiHeight / 2; ++i) {
            int n = (this.roiY + i) * this.width + this.roiX;
            int n2 = (this.roiY + this.roiHeight - 1 - i) * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                float f = this.pixels[n];
                this.pixels[n++] = this.pixels[n2];
                this.pixels[n2++] = f;
            }
        }
    }

    public void noise(double d) {
        Random random = new Random();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                float f = (float)(random.nextGaussian() * d);
                this.pixels[n] = this.pixels[n] + f;
                ++n;
            }
        }
        this.resetMinAndMax();
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        float[] fArray = (float[])imageProcessor.getPixels();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = (i - this.roiY) * this.roiWidth;
            int n2 = i * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                fArray[n++] = this.pixels[n2++];
            }
        }
        return imageProcessor;
    }

    public synchronized ImageProcessor duplicate() {
        ImageProcessor imageProcessor = this.createProcessor(this.width, this.height);
        float[] fArray = (float[])imageProcessor.getPixels();
        System.arraycopy(this.pixels, 0, fArray, 0, this.width * this.height);
        return imageProcessor;
    }

    public void scale(double d, double d2) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        float[] fArray = (float[])this.getPixelsCopy();
        FloatProcessor floatProcessor = null;
        if (this.interpolationMethod == 2) {
            floatProcessor = new FloatProcessor(this.getWidth(), this.getHeight(), fArray, null);
        }
        boolean bl2 = bl = d < 1.0 || d2 < 1.0;
        if (this.interpolationMethod == 2) {
            for (int i = n2; i <= n; ++i) {
                double d5 = ((double)i - d4) / d2 + d4;
                int n5 = i * this.width + n4;
                for (int j = n4; j <= n3; ++j) {
                    double d6 = ((double)j - d3) / d + d3;
                    this.pixels[n5++] = (float)this.getBicubicInterpolatedPixel(d6, d5, floatProcessor);
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        } else {
            double d7 = (double)this.width - 1.0;
            double d8 = (double)this.width - 1.001;
            double d9 = (double)this.height - 1.0;
            double d10 = (double)this.height - 1.001;
            for (int i = n2; i <= n; ++i) {
                double d11 = ((double)i - d4) / d2 + d4;
                int n6 = (int)d11;
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
                int n7 = i * this.width + n4;
                int n8 = this.width * (int)d11;
                for (int j = n4; j <= n3; ++j) {
                    double d12 = ((double)j - d3) / d + d3;
                    int n9 = (int)d12;
                    if (bl && (n9 < n4 || n9 > n3 || n6 < n2 || n6 > n)) {
                        this.pixels[n7++] = (float)this.getMin();
                        continue;
                    }
                    if (this.interpolationMethod == 1) {
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 >= d7) {
                            d12 = d8;
                        }
                        this.pixels[n7++] = (float)this.getInterpolatedPixel(d12, d11, fArray);
                        continue;
                    }
                    this.pixels[n7++] = fArray[n8 + n9];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        }
        this.showProgress(1.0);
    }

    private final double getInterpolatedPixel(double d, double d2, float[] fArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        double d5 = fArray[n3];
        double d6 = fArray[n3 + 1];
        double d7 = fArray[n3 + this.width + 1];
        double d8 = fArray[n3 + this.width];
        double d9 = d8 + d3 * (d7 - d8);
        double d10 = d5 + d3 * (d6 - d5);
        return d10 + d4 * (d9 - d10);
    }

    public ImageProcessor resize(int n, int n2) {
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        if (this.interpolationMethod != 0) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        float[] fArray = (float[])imageProcessor.getPixels();
        if (this.interpolationMethod == 2) {
            for (int i = 0; i <= n2 - 1; ++i) {
                double d7 = ((double)i - d4) / d6 + d2;
                int n3 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d8 = ((double)j - d3) / d5 + d;
                    fArray[n3++] = (float)this.getBicubicInterpolatedPixel(d8, d7, this);
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        } else {
            double d9 = (double)this.width - 1.0;
            double d10 = (double)this.width - 1.001;
            double d11 = (double)this.height - 1.0;
            double d12 = (double)this.height - 1.001;
            for (int i = 0; i <= n2 - 1; ++i) {
                double d13 = ((double)i - d4) / d6 + d2;
                if (this.interpolationMethod == 1) {
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (d13 >= d11) {
                        d13 = d12;
                    }
                }
                int n4 = this.width * (int)d13;
                int n5 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d14 = ((double)j - d3) / d5 + d;
                    if (this.interpolationMethod == 1) {
                        if (d14 < 0.0) {
                            d14 = 0.0;
                        }
                        if (d14 >= d9) {
                            d14 = d10;
                        }
                        fArray[n5++] = (float)this.getInterpolatedPixel(d14, d13, this.pixels);
                        continue;
                    }
                    fArray[n5++] = this.pixels[n4 + (int)d14];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        }
        this.showProgress(1.0);
        return imageProcessor;
    }

    FloatProcessor downsize(int n, int n2) {
        Rectangle rectangle = this.getRoi();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        FloatProcessor floatProcessor = this;
        if (n < n3) {
            floatProcessor = floatProcessor.downsize1D(n, this.getHeight());
            floatProcessor.setRoi(0, rectangle.y, n, n4);
        }
        if (n2 < n4) {
            floatProcessor = floatProcessor.downsize1D(n, n2);
        }
        if (floatProcessor.getWidth() != n || floatProcessor.getHeight() != n2) {
            floatProcessor = (FloatProcessor)floatProcessor.resize(n, n2);
        }
        return floatProcessor;
    }

    private FloatProcessor downsize1D(int n, int n2) {
        int n3 = this.getWidth();
        Rectangle rectangle = this.getRoi();
        boolean bl = n < rectangle.width;
        int n4 = bl ? 1 : n3;
        int n5 = bl ? n3 : 1;
        int n6 = bl ? 1 : n;
        int n7 = bl ? n : 1;
        int n8 = bl ? rectangle.x : rectangle.y;
        int n9 = bl ? n2 : n;
        DownsizeTable downsizeTable = bl ? new DownsizeTable(this.getWidth(), rectangle.x, rectangle.width, n, this.interpolationMethod) : new DownsizeTable(this.getHeight(), rectangle.y, rectangle.height, n2, this.interpolationMethod);
        FloatProcessor floatProcessor = (FloatProcessor)this.createProcessor(n, n2);
        float[] fArray = (float[])this.getPixels();
        float[] fArray2 = (float[])floatProcessor.getPixels();
        int n10 = n8;
        for (int i = 0; i < n9; ++i) {
            int n11 = i * n7;
            int n12 = 0;
            int n13 = downsizeTable.srcStart;
            int n14 = n13 * n4 + n10 * n5;
            while (n13 <= downsizeTable.srcEnd) {
                float f = fArray[n14];
                int n15 = 0;
                while (n15 < downsizeTable.kernelSize) {
                    int n16 = n11 + downsizeTable.indices[n12] * n6;
                    fArray2[n16] = fArray2[n16] + f * downsizeTable.weights[n12];
                    ++n15;
                    ++n12;
                }
                ++n13;
                n14 += n4;
            }
            ++n10;
        }
        return floatProcessor;
    }

    public double getBicubicInterpolatedPixel(double d, double d2, ImageProcessor imageProcessor) {
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        if (n <= 0 || n >= this.width - 2 || n2 <= 0 || n2 >= this.height - 2) {
            return imageProcessor.getBilinearInterpolatedPixel(d, d2);
        }
        double d3 = 0.0;
        for (int i = 0; i <= 3; ++i) {
            int n3 = n2 - 1 + i;
            double d4 = 0.0;
            for (int j = 0; j <= 3; ++j) {
                int n4 = n - 1 + j;
                d4 += (double)imageProcessor.getf(n4, n3) * FloatProcessor.cubic(d - (double)n4);
            }
            d3 += d4 * FloatProcessor.cubic(d2 - (double)n3);
        }
        return d3;
    }

    public void setColor(Color color) {
        int n = this.getBestIndex(color);
        if (n > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.fillColor = n;
            this.setMinAndMax(0.0, 255.0);
        } else {
            this.fillColor = n == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0 ? 0.0f : (float)(this.getMin() + (this.getMax() - this.getMin()) * ((double)n / 255.0));
        }
    }

    public void setValue(double d) {
        this.fillColor = (float)d;
    }

    public void setBackgroundValue(double d) {
    }

    public double getBackgroundValue() {
        return 0.0;
    }

    public void setThreshold(double d, double d2, int n) {
        if (d == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (this.getMax() > this.getMin()) {
            double d3 = Math.round((d - this.getMin()) / (this.getMax() - this.getMin()) * 255.0);
            double d4 = Math.round((d2 - this.getMin()) / (this.getMax() - this.getMin()) * 255.0);
            super.setThreshold(d3, d4, n);
        } else {
            super.resetThreshold();
        }
        this.minThreshold = d;
        this.maxThreshold = d2;
    }

    public void convolve(float[] fArray, int n, int n2) {
        this.snapshot();
        new Convolver().convolve(this, fArray, n, n2);
    }

    public void threshold(int n) {
    }

    public void autoThreshold() {
    }

    public void medianFilter() {
    }

    public int[] getHistogram() {
        return null;
    }

    public void erode() {
    }

    public void dilate() {
    }

    public FloatProcessor toFloat(int n, FloatProcessor floatProcessor) {
        return this;
    }

    public void setPixels(int n, FloatProcessor floatProcessor) {
        if (floatProcessor.getPixels() != this.getPixels()) {
            this.setPixels(floatProcessor.getPixels());
        }
        this.setMinAndMax(floatProcessor.getMin(), floatProcessor.getMax());
    }

    public double minValue() {
        return 1.4E-45f;
    }

    public double maxValue() {
        return 3.4028234663852886E38;
    }
}

