/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class StackStatistics
extends ImageStatistics {
    public StackStatistics(ImagePlus imagePlus) {
        this(imagePlus, 256, 0.0, 0.0);
    }

    public StackStatistics(ImagePlus imagePlus, int n, double d, double d2) {
        int n2 = imagePlus.getBitDepth();
        if ((n2 == 8 || n2 == 24) && n == 256 && d == 0.0 && d2 == 256.0) {
            this.sum8BitHistograms(imagePlus);
        } else if (n2 == 16 && n == 256 && d == 0.0 && d2 == 0.0 && !imagePlus.getCalibration().calibrated()) {
            this.sum16BitHistograms(imagePlus);
        } else {
            this.doCalculations(imagePlus, n, d, d2);
        }
    }

    void doCalculations(ImagePlus imagePlus, int n, double d, double d2) {
        double d3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        boolean bl = (Analyzer.getMeasurements() & 0x100) != 0;
        double d4 = -3.4028234663852886E38;
        double d5 = 3.4028234663852886E38;
        Calibration calibration = imagePlus.getCalibration();
        if (bl && imageProcessor.getMinThreshold() != -808080.0) {
            d4 = calibration.getCValue(imageProcessor.getMinThreshold());
            d5 = calibration.getCValue(imageProcessor.getMaxThreshold());
        }
        this.nBins = n;
        this.histMin = d;
        this.histMax = d2;
        ImageStack imageStack = imagePlus.getStack();
        int n10 = imageStack.getSize();
        imageProcessor.setRoi(imagePlus.getRoi());
        byte[] byArray = imageProcessor.getMaskArray();
        float[] fArray = imagePlus.getCalibration().getCTable();
        this.histogram = new int[this.nBins];
        double d6 = 0.0;
        double d7 = 0.0;
        int n11 = imageProcessor.getWidth();
        int n12 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle != null) {
            n9 = rectangle.x;
            n8 = rectangle.y;
            n7 = rectangle.width;
            n6 = rectangle.height;
        } else {
            n9 = 0;
            n8 = 0;
            n7 = n11;
            n6 = n12;
        }
        double d8 = 1.0;
        double d9 = 1.0;
        this.roiX = (double)n9 * d8;
        this.roiY = (double)n8 * d9;
        this.roiWidth = (double)n7 * d8;
        this.roiHeight = (double)n6 * d9;
        boolean bl2 = this.histMin != 0.0 || this.histMax != 0.0;
        double d10 = Double.MAX_VALUE;
        double d11 = -1.7976931348623157E308;
        for (int i = 1; i <= n10; ++i) {
            IJ.showStatus("Calculating stack histogram...");
            IJ.showProgress(i / 2, n10);
            imageProcessor = imageStack.getProcessor(i);
            int n13 = n8;
            n5 = 0;
            while (n13 < n8 + n6) {
                n4 = n13 * n11 + n9;
                n3 = n5 * n7;
                for (n2 = n9; n2 < n9 + n7; ++n2) {
                    if ((byArray == null || byArray[n3++] != 0) && (d3 = (double)imageProcessor.getPixelValue(n2, n13)) >= d4 && d3 <= d5) {
                        if (d3 < d10) {
                            d10 = d3;
                        }
                        if (d3 > d11) {
                            d11 = d3;
                        }
                    }
                    ++n4;
                }
                ++n13;
                ++n5;
            }
        }
        this.min = d10;
        this.max = d11;
        if (bl2) {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        } else {
            this.histMin = this.min;
            this.histMax = this.max;
        }
        double d12 = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        n4 = 1;
        for (n3 = 1; n3 <= n10; ++n3) {
            IJ.showProgress(n10 / 2 + n3 / 2, n10);
            imageProcessor = imageStack.getProcessor(n3);
            imageProcessor.setCalibrationTable(fArray);
            n2 = n8;
            int n14 = 0;
            while (n2 < n8 + n6) {
                int n15 = n2 * n11 + n9;
                int n16 = n14 * n7;
                for (int i = n9; i < n9 + n7; ++i) {
                    if ((byArray == null || byArray[n16++] != 0) && (d3 = (double)imageProcessor.getPixelValue(i, n2)) >= d4 && d3 <= d5 && d3 >= this.histMin && d3 <= this.histMax) {
                        ++this.longPixelCount;
                        d6 += d3;
                        d7 += d3 * d3;
                        n5 = (int)(d12 * (d3 - this.histMin));
                        if (n5 >= this.nBins) {
                            n5 = this.nBins - 1;
                        }
                        int n17 = n5;
                        this.histogram[n17] = this.histogram[n17] + 1;
                    }
                    ++n15;
                }
                ++n2;
                ++n14;
            }
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * d8 * d9;
        this.mean = d6 / (double)this.longPixelCount;
        this.calculateStdDev(this.longPixelCount, d6, d7);
        this.histMin = calibration.getRawValue(this.histMin);
        this.histMax = calibration.getRawValue(this.histMax);
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        n3 = imagePlus.getBitDepth();
        if (this.histMin == 0.0 && this.histMax == 256.0 && (n3 == 8 || n3 == 24)) {
            this.histMax = 255.0;
        }
        this.dmode = this.getMode(calibration);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    void sum8BitHistograms(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        boolean bl = (Analyzer.getMeasurements() & 0x100) != 0;
        int n = 0;
        int n2 = 255;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (bl && imageProcessor.getMinThreshold() != -808080.0) {
            n = (int)imageProcessor.getMinThreshold();
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        ImageStack imageStack = imagePlus.getStack();
        Roi roi = imagePlus.getRoi();
        this.histogram = new int[256];
        int n3 = imageStack.getSize();
        for (int i = 1; i <= n3; ++i) {
            IJ.showProgress(i, n3);
            imageProcessor = imageStack.getProcessor(i);
            if (roi != null) {
                imageProcessor.setRoi(roi);
            }
            int[] nArray = imageProcessor.getHistogram();
            for (int j = 0; j < 256; ++j) {
                int n4 = j;
                this.histogram[n4] = this.histogram[n4] + nArray[j];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.getRawStatistics(n, n2);
        this.getRawMinAndMax(n, n2);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    void sum16BitHistograms(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        boolean bl = (Analyzer.getMeasurements() & 0x100) != 0;
        int n = 0;
        int n2 = 65535;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (bl && imageProcessor.getMinThreshold() != -808080.0) {
            n = (int)imageProcessor.getMinThreshold();
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        ImageStack imageStack = imagePlus.getStack();
        Roi roi = imagePlus.getRoi();
        int[] nArray = new int[65536];
        int n3 = imageStack.getSize();
        for (int i = 1; i <= n3; ++i) {
            IJ.showProgress(i, n3);
            IJ.showStatus(i + "/" + n3);
            imageProcessor = imageStack.getProcessor(i);
            if (roi != null) {
                imageProcessor.setRoi(roi);
            }
            int[] nArray2 = imageProcessor.getHistogram();
            for (int j = 0; j < 65536; ++j) {
                int n4 = j;
                nArray[n4] = nArray[n4] + nArray2[j];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.getRaw16BitMinAndMax(nArray, n, n2);
        this.get16BitStatistics(nArray, (int)this.min, (int)this.max);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    void getRaw16BitMinAndMax(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        for (n4 = n; nArray[n4] == 0 && n4 < 65535; ++n4) {
        }
        this.min = n4;
        for (n3 = n2; nArray[n3] == 0 && n3 > 0; --n3) {
        }
        this.max = n3;
    }

    void get16BitStatistics(int[] nArray, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        this.nBins = 256;
        this.histMin = n;
        this.histMax = n2;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d3 = 1.0 / this.binSize;
        int n3 = (int)this.histMin;
        this.histogram = new int[this.nBins];
        this.maxCount = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = nArray[i];
            this.longPixelCount += (long)n4;
            double d4 = i;
            d += d4 * (double)n4;
            d2 += d4 * d4 * (double)n4;
            int n5 = (int)(d3 * (double)(i - n3));
            if (n5 >= this.nBins) {
                n5 = this.nBins - 1;
            }
            int n6 = n5;
            this.histogram[n6] = this.histogram[n6] + n4;
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.longPixelCount;
        this.dmode = this.getMode(null);
        this.calculateStdDev(this.longPixelCount, d, d2);
    }

    double getMode(Calibration calibration) {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int n = this.histogram[i];
            if (n <= this.maxCount) continue;
            this.maxCount = n;
            this.mode = i;
        }
        double d = this.histMin + (double)this.mode * this.binSize;
        if (calibration != null) {
            d = calibration.getCValue(d);
        }
        return d;
    }
}

