% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\title{Creates an app config file, "config.cfg"}
\usage{
create_config(app_name, R_version, app_dir, repo = "http://cran.rstudio.com",
  error_log = "error.log", app_repo_url = "none", auth_user = "none",
  auth_pw = "none")
}
\arguments{
\item{app_name}{The name of the app being installed. It will be displayed throughout the installer and uninstaller in window titles, wizard pages, and dialog boxes. See \href{http://www.jrsoftware.org/ishelp/topic_setup_appname.htm}{[Setup]:AppName} for details. For continuous deployments, \code{app_name} is used to check for an R package of the same name, and update it. The Deployment vignette has more details.}

\item{R_version}{R version to use, defaults to: \code{paste0(R.version$major, '.', R.version$minor)}.}

\item{app_dir}{Shiny app's directory, defaults to \code{getwd()}.}

\item{repo}{Default repository to install package dependencies from.}

\item{error_log}{Name of error logging file. Contains start up errors from \emph{run.R}.}

\item{app_repo_url}{Repository address in the format \code{"https://bitbucket.org/username/repo"} (\code{repo = app_name}). Only Bitbucket and GitHub repositories are supported.}

\item{auth_user}{Authorized username. It is recommended to create a read-only account for each app.  Support for OAuth 2 and tokens is in the works.}

\item{auth_pw}{Password to Bitbucket or Github.}
}
\value{
A json file, \emph{config.cfg}, in \code{app_dir}.
}
\description{
Creates an app config file, "config.cfg"
}
\seealso{
\code{\link{create_app}}.
}
\author{
Jonathan M. Hill
}
