/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.calendars.IDayInfo;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;

public class EasterRelatedDay
implements ISpecialDay {
    private static final Map<Integer, Day> dic = new HashMap<Integer, Day>();
    private static final Map<Integer, Day> jdic = new HashMap<Integer, Day>();
    private static final int[] g_days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public final int offset;
    private final double weight;
    private final boolean julian;
    public static final EasterRelatedDay ShroveMonday = new EasterRelatedDay(-48);
    public static final EasterRelatedDay ShroveTuesday = new EasterRelatedDay(-47);
    public static final EasterRelatedDay AshWednesday = new EasterRelatedDay(-46);
    public static final EasterRelatedDay Easter = new EasterRelatedDay(0);
    public static final EasterRelatedDay EasterMonday = new EasterRelatedDay(1);
    public static final EasterRelatedDay EasterFriday = new EasterRelatedDay(-2);
    public static final EasterRelatedDay EasterThursday = new EasterRelatedDay(-3);
    public static final EasterRelatedDay Ascension = new EasterRelatedDay(39);
    public static final EasterRelatedDay Pentecost = new EasterRelatedDay(49);
    public static final EasterRelatedDay PentecostMonday = new EasterRelatedDay(50);
    public static final EasterRelatedDay CorpusChristi = new EasterRelatedDay(60);
    public static final EasterRelatedDay JulianShroveMonday = new EasterRelatedDay(-48, true);
    public static final EasterRelatedDay JulianShroveTuesday = new EasterRelatedDay(-47, true);
    public static final EasterRelatedDay JulianAshWednesday = new EasterRelatedDay(-46, true);
    public static final EasterRelatedDay JulianEaster = new EasterRelatedDay(0, true);
    public static final EasterRelatedDay JulianEasterMonday = new EasterRelatedDay(1, true);
    public static final EasterRelatedDay JulianEasterFriday = new EasterRelatedDay(-2, true);
    public static final EasterRelatedDay JulianEasterThursday = new EasterRelatedDay(-3, true);
    public static final EasterRelatedDay JulianAscension = new EasterRelatedDay(39, true);
    public static final EasterRelatedDay JulianPentecost = new EasterRelatedDay(49, true);
    public static final EasterRelatedDay JulianPentecostMonday = new EasterRelatedDay(50, true);
    public static final EasterRelatedDay JulianCorpusChristi = new EasterRelatedDay(60, true);
    private static int START = 80;
    private static int JSTART = 90;
    private static int DEL = 35;
    private static int JDEL = 43;

    public EasterRelatedDay() {
        this(0, 1.0, false);
    }

    public EasterRelatedDay(int offset) {
        this(offset, 1.0, false);
    }

    public EasterRelatedDay(int offset, boolean julian) {
        this(offset, 1.0, julian);
    }

    public EasterRelatedDay(int offset, double weight) {
        this(offset, weight, false);
    }

    public EasterRelatedDay(int offset, double weight, boolean julian) {
        this.weight = weight;
        this.offset = offset;
        this.julian = julian;
    }

    public EasterRelatedDay reweight(double nweight) {
        if (nweight == this.weight) {
            return this;
        }
        return new EasterRelatedDay(this.offset, nweight, this.julian);
    }

    public EasterRelatedDay plus(int ndays) {
        return new EasterRelatedDay(this.offset + ndays, this.weight, this.julian);
    }

    public boolean isJulian() {
        return this.julian;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean match(ISpecialDay.Context context) {
        return context.isJulianEaster() == this.julian;
    }

    public Day calcDay(int year) {
        Day d = this.easter(year);
        if (this.offset != 0) {
            d = d.plus(this.offset);
        }
        return d;
    }

    private Day easter(int year) {
        return EasterRelatedDay.easter(year, this.julian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Day easter(int year, boolean jul) {
        if (jul) {
            Map<Integer, Day> map = jdic;
            synchronized (map) {
                Day e = jdic.get(year);
                if (e == null) {
                    e = Utilities.julianEaster3(year, true);
                    jdic.put(year, e);
                }
                return e;
            }
        }
        Map<Integer, Day> map = dic;
        synchronized (map) {
            Day e = dic.get(year);
            if (e == null) {
                e = Utilities.easter(year);
                dic.put(year, e);
            }
            return e;
        }
    }

    private double probEaster(int del) {
        return this.julian ? Utilities.probJulianEaster(del) : Utilities.probEaster(del);
    }

    @Override
    public Iterable<IDayInfo> getIterable(TsFrequency freq, Day start, Day end) {
        return new EasterDayList(freq, this.offset, start, end, this.julian);
    }

    @Override
    public double[][] getLongTermMeanEffect(int freq) {
        int d1;
        int d0;
        int w = this.offset % 7;
        if (w == 0) {
            return null;
        }
        if (w < 0) {
            w += 7;
        }
        --w;
        if (this.julian) {
            d0 = JSTART + this.offset;
            d1 = d0 + JDEL;
        } else {
            d0 = START + this.offset;
            d1 = d0 + DEL;
        }
        int ifreq = freq;
        int c = 12 / ifreq;
        int c0 = 0;
        int c1 = 0;
        for (int i = 0; i < c; ++i) {
            c1 += g_days[i];
        }
        double[][] rslt = new double[ifreq][];
        int i = 0;
        while (i < ifreq) {
            if (d0 < c1 && d1 > c0) {
                double[] m = new double[7];
                double x = 0.0;
                for (int j = Math.max(d0, c0); j < Math.min(d1, c1); ++j) {
                    x += this.probEaster(j - d0);
                }
                m[w] = x * this.weight;
                m[6] = -m[w];
                rslt[i] = m;
            }
            c0 = c1;
            if (++i >= ifreq) continue;
            for (int j = 0; j < c; ++j) {
                c1 += g_days[i * c + j];
            }
        }
        return rslt;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EasterRelatedDay && this.equals((EasterRelatedDay)obj);
    }

    private boolean equals(EasterRelatedDay other) {
        return other.offset == this.offset && other.weight == this.weight && other.julian == this.julian;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.offset;
        return hash;
    }

    @Override
    public TsDomain getSignificantDomain(TsFrequency freq, Day start, Day end) {
        Day eday;
        TsPeriod pstart = new TsPeriod(freq, start);
        TsPeriod pend = new TsPeriod(freq, end);
        Day sday = this.easter(pstart.getYear()).plus(this.offset);
        if (start.isAfter(sday)) {
            pstart.move(1);
        }
        if (end.isBefore(eday = this.easter(pend.getYear()).plus(this.offset))) {
            pend.move(-1);
        }
        int n = pend.minus(pstart) + 1;
        return new TsDomain(pstart, Math.max(0, n));
    }

    static class EasterDayList
    extends AbstractList<IDayInfo> {
        private final int m_startyear;
        private final int m_n;
        private final int m_offset;
        private final TsFrequency m_freq;
        private final boolean julian;

        public EasterDayList(TsFrequency freq, int offset, Day fstart, Day fend, boolean julian) {
            this.m_freq = freq;
            this.m_offset = offset;
            this.julian = julian;
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            Day xday = EasterRelatedDay.easter(ystart, julian).plus(offset);
            Day yday = EasterRelatedDay.easter(yend, julian).plus(offset);
            if (xday.isBefore(fstart)) {
                ++ystart;
            }
            if (fend.isNotBefore(yday)) {
                ++yend;
            }
            this.m_n = yend - ystart;
            this.m_startyear = ystart;
        }

        @Override
        public IDayInfo get(int index) {
            return new EasterDayInfo(this.m_freq, this.m_startyear + index, this.m_offset, this.julian);
        }

        @Override
        public int size() {
            return this.m_n;
        }
    }

    static class EasterDayInfo
    implements IDayInfo {
        final Day m_day;
        final TsFrequency m_freq;

        public EasterDayInfo(TsFrequency freq, int year, int offset, boolean julian) {
            Day easter = EasterRelatedDay.easter(year, julian);
            this.m_day = easter.plus(offset);
            this.m_freq = freq;
        }

        @Override
        public Day getDay() {
            return this.m_day;
        }

        @Override
        public TsPeriod getPeriod() {
            TsPeriod p = new TsPeriod(this.m_freq);
            p.set(this.m_day);
            return p;
        }

        @Override
        public DayOfWeek getDayOfWeek() {
            return this.m_day.getDayOfWeek();
        }
    }
}

