/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.AnsleyFilter;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.IResidualsComputer;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class ExactSingleOutlierDetector<T extends IArimaModel>
extends AbstractSingleOutlierDetector<T> {
    private IArmaFilter m_filter;
    private final IResidualsComputer resComputer;
    private Matrix m_L;
    private Matrix m_X;
    private double[] m_yl;
    private double[] m_b;
    private double[] m_w;
    private int m_n;

    public ExactSingleOutlierDetector() {
        this(IRobustStandardDeviationComputer.mad());
    }

    public ExactSingleOutlierDetector(IRobustStandardDeviationComputer computer) {
        this(computer, null);
    }

    public ExactSingleOutlierDetector(IRobustStandardDeviationComputer computer, IArmaFilter filter) {
        super(computer);
        this.m_filter = filter == null ? new AnsleyFilter() : filter;
        this.resComputer = IResidualsComputer.defaultComputer(this.m_filter.exemplar());
    }

    public ExactSingleOutlierDetector(IRobustStandardDeviationComputer computer, IResidualsComputer resComputer, IArmaFilter filter) {
        super(computer);
        this.m_filter = filter == null ? new AnsleyFilter() : filter;
        this.resComputer = resComputer;
    }

    @Override
    protected boolean calc() {
        try {
            RegModel dmodel = this.getModel().getDModel();
            this.m_n = this.m_filter.initialize((IArimaModel)this.getModel().getArma(), dmodel.getObsCount());
            if (!this.initialize(dmodel)) {
                return false;
            }
            for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
                this.processOutlier(i);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    protected boolean initialize(RegModel model) {
        try {
            this.m_yl = new double[this.m_n];
            DataBlock YL = new DataBlock(this.m_yl);
            this.m_filter.filter(model.getY(), YL);
            Matrix regs = model.variables();
            if (regs == null) {
                this.getStandardDeviationComputer().compute(this.filter(model.getY()));
                return true;
            }
            this.m_X = new Matrix(this.m_n, regs.getColumnsCount());
            DataBlockIterator rcols = regs.columns();
            DataBlockIterator drcols = this.m_X.columns();
            DataBlock rcol = rcols.getData();
            DataBlock drcol = drcols.getData();
            do {
                this.m_filter.filter(rcol, drcol);
            } while (rcols.next() && drcols.next());
            Householder qr = new Householder(true);
            qr.decompose(this.m_X);
            int[] unused = qr.getUnused();
            int nx = this.m_X.getColumnsCount();
            if (unused != null) {
                Matrix tmp = new Matrix(this.m_n, nx -= unused.length);
                int i = 0;
                int j = 0;
                while (j < nx) {
                    if (ExactSingleOutlierDetector.isUsed(i, unused)) {
                        tmp.column(j++).copy(this.m_X.column(i));
                    }
                    ++i;
                }
                this.m_X = tmp;
                drcols = this.m_X.columns();
                drcol = drcols.getData();
            }
            this.m_b = new double[nx];
            qr.leastSquares(YL, new DataBlock(this.m_b), null);
            this.m_w = new double[nx];
            this.m_L = qr.getR().transpose();
            DataBlock all = unused == null ? new DataBlock(this.m_b) : this.expand(this.m_b, unused);
            DataBlock e = model.calcRes(all);
            this.getStandardDeviationComputer().compute(this.filter(e));
            drcols.begin();
            do {
                this.m_w[drcols.getPosition()] = drcol.dot(YL);
            } while (drcols.next());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isUsed(int i, int[] unused) {
        for (int k = 0; k < unused.length; ++k) {
            if (i != unused[k]) continue;
            return false;
        }
        return true;
    }

    private DataBlock expand(double[] b, int[] unused) {
        double[] c = new double[b.length + unused.length];
        int j = 0;
        for (int i = 0; i < c.length; ++i) {
            if (!ExactSingleOutlierDetector.isUsed(i, unused)) continue;
            c[i] = b[j++];
        }
        return new DataBlock(c);
    }

    protected void processOutlier(int idx) {
        int n = this.getModel().getY().getLength();
        int d = this.getModel().getDifferencingFilter().getDegree();
        double[] o = new double[2 * n];
        DataBlock O = new DataBlock(o);
        TsPeriod start = this.getDomain().getStart();
        IOutlierVariable outlier = this.getOutlierFactory(idx).create(start.firstday());
        outlier.data(start.minus(n), O);
        double[] od = new double[o.length - d];
        DataBlock OD = new DataBlock(od);
        this.getModel().getDifferencingFilter().filter(O, OD);
        DataBlock OL = new DataBlock(od, n, 2 * n - d, 1);
        for (int i = 0; i < n; ++i) {
            if (this.isDefined(i, idx)) {
                double[] u = new double[this.m_n];
                DataBlock U = new DataBlock(u);
                this.m_filter.filter(OL, U);
                double xx = 0.0;
                double xy = 0.0;
                for (int j = 0; j < u.length; ++j) {
                    xx += u[j] * u[j];
                    xy += u[j] * this.m_yl[j];
                }
                if (this.m_L != null) {
                    double[] l = new double[this.m_b.length];
                    DataBlockIterator xcols = this.m_X.columns();
                    DataBlock xcol = xcols.getData();
                    do {
                        l[xcols.getPosition()] = xcol.dot(U);
                    } while (xcols.next());
                    DataBlock L = new DataBlock(l);
                    LowerTriangularMatrix.rsolve(this.m_L, l);
                    double q = L.dot(L);
                    double c = xx - q;
                    if (c <= 0.0) {
                        this.exclude(i, idx);
                    } else {
                        LowerTriangularMatrix.lsolve(this.m_L, l);
                        this.setT(i, idx, (xy - new DataBlock(this.m_w).dot(L)) / Math.sqrt(c) / this.getMAD());
                    }
                } else if (xx <= 0.0) {
                    this.exclude(i, idx);
                } else {
                    this.setT(i, idx, xy / Math.sqrt(xx) / this.getMAD());
                }
            }
            OL.move(-1);
        }
    }

    protected DataBlock filter(DataBlock res) {
        return this.resComputer.residuals((IArimaModel)this.getModel().getArma(), res);
    }

    @Override
    protected void clear(boolean all) {
        super.clear(all);
        this.m_L = null;
        this.m_X = null;
        this.m_b = null;
        this.m_w = null;
    }
}

