/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.KalmanFilter;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import java.util.concurrent.atomic.AtomicLong;

public class ConcentratedLikelihoodEstimation {
    public static final AtomicLong fnCalls = new AtomicLong(0L);
    private final IArmaFilter m_filter;
    private boolean m_scaling = true;
    private ConcentratedLikelihood m_ll;
    private double[] m_el;

    public ConcentratedLikelihoodEstimation() {
        this.m_filter = new KalmanFilter(true);
    }

    public ConcentratedLikelihoodEstimation(IArmaFilter filter) {
        this.m_filter = filter.exemplar();
    }

    public void setScaling(boolean scaling) {
        this.m_scaling = scaling;
    }

    public boolean isScaling() {
        return this.m_scaling;
    }

    public <S extends IArimaModel> boolean estimate(RegArimaModel<S> model) {
        RegModel dmodel = model.getDModel();
        return this.estimate(dmodel, model.getArima().getNonStationaryARCount(), model.getMissings(), (IArimaModel)model.getArma());
    }

    public boolean estimate(RegModel dmodel, int d, int[] missings, IArimaModel arma) {
        DataBlock dy = dmodel.getY();
        int n = dy.getLength();
        int nl = this.m_filter.initialize(arma, n);
        try {
            return this.process(dmodel, nl, d, missings);
        }
        catch (BaseException ex) {
            return false;
        }
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.m_ll;
    }

    public double[] getResiduals() {
        return this.m_el;
    }

    private boolean process(RegModel model, int nl, int nd, int[] missings) {
        int nx;
        double yn;
        fnCalls.incrementAndGet();
        this.m_ll = new ConcentratedLikelihood();
        DataBlock y = model.getY().deepClone();
        int n = y.getLength();
        double[] factors = null;
        double yfactor = 1.0;
        if (this.m_scaling && (yn = y.nrm2()) != 0.0) {
            yfactor = (double)n / yn;
            y.mul(yfactor);
        }
        DataBlock yl = new DataBlock(nl);
        this.m_filter.filter(y, yl);
        Matrix x = model.variables();
        int n2 = nx = x == null ? 0 : x.getColumnsCount();
        if (nx > 0) {
            int i;
            if (this.m_scaling) {
                factors = new double[nx];
                for (int i2 = 0; i2 < nx; ++i2) {
                    DataBlock cur = x.column(i2);
                    double xn = cur.nrm2();
                    if (xn != 0.0) {
                        double w;
                        factors[i2] = w = (double)n / xn;
                        cur.mul(w);
                        continue;
                    }
                    factors[i2] = 1.0;
                }
            }
            Matrix xl = new Matrix(nl, x.getColumnsCount());
            DataBlockIterator xcols = x.columns();
            DataBlockIterator xlcols = xl.columns();
            DataBlock xcol = xcols.getData();
            DataBlock xlcol = xlcols.getData();
            do {
                this.m_filter.filter(xcol, xlcol);
            } while (xcols.next() && xlcols.next());
            Householder qr = new Householder(true);
            qr.setEpsilon(1.0E-12);
            qr.decompose(xl);
            if (qr.getRank() == 0) {
                double ssqerr = yl.ssq();
                double ldet = this.m_filter.getLogDeterminant();
                this.m_ll.set(ssqerr, ldet, n);
                this.m_ll.setRes(yl.getData());
                this.m_ll.setB(new double[nx], new Matrix(nx, nx), 0);
                if (this.m_scaling) {
                    this.m_ll.rescale(yfactor);
                }
                this.m_el = this.m_ll.getResiduals();
                return true;
            }
            DataBlock b = new DataBlock(qr.getRank());
            DataBlock res = new DataBlock(nl - qr.getRank());
            qr.leastSquares(yl, b, res);
            Matrix R = qr.getR();
            double ssqerr = res.ssq();
            int nm = missings == null ? 0 : missings.length;
            double ldet = this.m_filter.getLogDeterminant();
            if (nm > 0) {
                int mstart = model.isMeanCorrection() ? 1 : 0;
                DataBlock rdiag = qr.getRDiagonal().extract(mstart, nm);
                double corr = rdiag.sumLog().value;
                if (this.m_scaling) {
                    for (i = 0; i < nm; ++i) {
                        corr -= Math.log(factors[mstart + i]);
                    }
                }
                ldet += 2.0 * corr;
                n -= nm;
            }
            Matrix bvar = SymmetricMatrix.XXt(UpperTriangularMatrix.inverse(R));
            bvar.mul(ssqerr / (double)n);
            int[] unused = qr.getUnused();
            if (unused != null) {
                double[] bc = new double[nx];
                Matrix bvarc = new Matrix(nx, nx);
                int j = 0;
                int k = 0;
                for (i = 0; i < nx; ++i) {
                    if (k < unused.length && i == unused[k]) {
                        ++k;
                        continue;
                    }
                    bc[i] = b.get(j);
                    int cj = 0;
                    int ck = 0;
                    for (int ci = 0; ci <= i; ++ci) {
                        if (ck < unused.length && ci == unused[ck]) {
                            ++ck;
                            continue;
                        }
                        double d = bvar.get(j, cj);
                        bvarc.set(i, ci, d);
                        bvarc.set(ci, i, d);
                        ++cj;
                    }
                    ++j;
                }
                b = new DataBlock(bc);
                bvar = bvarc;
            }
            this.m_ll.set(ssqerr, ldet, n);
            this.m_ll.setRes(res.getData());
            this.m_ll.setB(b.getData(), bvar, qr.getRank() - nm);
            DataBlock el = yl.deepClone();
            for (int i3 = 0; i3 < nx; ++i3) {
                el.addAY(-b.get(i3), xl.column(i3));
            }
            if (this.m_scaling) {
                this.m_ll.rescale(yfactor, factors);
                el.div(yfactor);
            }
            this.m_el = el.getData();
            return true;
        }
        double ssqerr = yl.ssq();
        double ldet = this.m_filter.getLogDeterminant();
        this.m_ll.set(ssqerr, ldet, n);
        this.m_ll.setRes(yl.getData());
        if (this.m_scaling) {
            this.m_ll.rescale(yfactor);
        }
        this.m_el = this.m_ll.getResiduals();
        return true;
    }
}

