/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;

public class Uniform
implements IContinuousDistribution {
    private double m_max;
    private double m_min;

    @Override
    public double getDensity(double x) throws DStatException {
        if (this.m_min >= this.m_max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        return 1.0 / (this.m_max - this.m_min);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uniform distribution with Lower bound = ");
        sb.append(this.m_min);
        sb.append(" and Upper bound = ");
        sb.append(this.m_max);
        return sb.toString();
    }

    @Override
    public double getExpectation() {
        return (this.m_max - this.m_min) / 2.0;
    }

    @Override
    public double getLeftBound() {
        return this.m_min;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMin() {
        return this.m_min;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        if (this.m_min >= this.m_max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        if (x < this.m_min || x > this.m_max) {
            throw new DStatException("The argument must lie between Min and Max", "Uniform");
        }
        double res = (x - this.m_min) / (this.m_max - this.m_min);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        if (p < 0.0 || p > 1.0) {
            throw new DStatException("x mus respect 0.0 <= x <= 1.0", "Uniform");
        }
        if (this.m_min >= this.m_max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        return p * (this.m_max - this.m_min) + this.m_min;
    }

    @Override
    public double getRightBound() {
        return this.m_max;
    }

    @Override
    public double getVariance() {
        return ((this.m_max - this.m_min + 1.0) * (this.m_max - this.m_min) - 1.0) / 12.0;
    }

    @Override
    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.Finite;
    }

    @Override
    public boolean isSymmetrical() {
        return true;
    }

    @Override
    public double random(IRandomNumberGenerator rng) throws DStatException {
        if (rng == null) {
            throw new DStatException("No valid Random Number Generator", "Uniform");
        }
        return StochasticRandomizer.uniform(rng, this.m_min, this.m_max);
    }

    public void setMax(double max) {
        this.m_max = max;
    }

    public void setMin(double min) {
        this.m_min = min;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("U(");
        sb.append(this.m_min);
        sb.append(',');
        sb.append(this.m_max);
        sb.append(')');
        return sb.toString();
    }
}

