/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.utilities.StringFormatter;
import java.util.Objects;

public class ChangeOfRegimeSpec
implements Cloneable {
    private Day day_;
    private Type type_;

    public ChangeOfRegimeSpec(Day day) {
        this.day_ = day;
        this.type_ = Type.Full;
    }

    public ChangeOfRegimeSpec(Day day, Type type) {
        this.day_ = day;
        this.type_ = type;
    }

    public ChangeOfRegimeSpec clone() {
        try {
            ChangeOfRegimeSpec spec = (ChangeOfRegimeSpec)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Day getDate() {
        return this.day_;
    }

    public void setDate(Day date) {
        this.day_ = date;
    }

    public Type getType() {
        return this.type_;
    }

    public void setType(Type type) {
        this.type_ = type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.day_);
        hash = 71 * hash + Objects.hashCode((Object)this.type_);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ChangeOfRegimeSpec && this.equals((ChangeOfRegimeSpec)obj);
    }

    private boolean equals(ChangeOfRegimeSpec other) {
        return other.day_.equals((Object)this.day_) && other.type_ == this.type_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        if (this.type_ == Type.Partial_ZeroStart) {
            builder.append('/');
        }
        builder.append(StringFormatter.convert(this.day_));
        if (this.type_ == Type.Partial_ZeroEnd) {
            builder.append('/');
        }
        builder.append('/');
        return builder.toString();
    }

    public static ChangeOfRegimeSpec fromString(String s) {
        Type type;
        int beg = 0;
        int end = s.length();
        if (end < 3 || s.charAt(beg) != '/' || s.charAt(end - 1) != '/') {
            return null;
        }
        --end;
        if (s.charAt(++beg) == '/') {
            ++beg;
            type = Type.Partial_ZeroStart;
        } else if (s.charAt(end - 1) == '/') {
            --end;
            type = Type.Partial_ZeroEnd;
        } else {
            type = Type.Full;
        }
        Day day = StringFormatter.convertDay(s.substring(beg, end));
        if (day == null) {
            return null;
        }
        return new ChangeOfRegimeSpec(day, type);
    }

    public static enum Type {
        Full,
        Partial_ZeroStart,
        Partial_ZeroEnd;

    }
}

