/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class OutlierSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String TYPES = "types";
    public static final String VA = "va";
    public static final String EML = "eml";
    public static final String DELTATC = "deltatc";
    private ArrayList<OutlierType> types_;
    private double tc_ = 0.7;
    private boolean eml_ = false;
    private double cv_ = 0.0;
    private TsPeriodSelector span_ = new TsPeriodSelector();
    public static final double DEF_DELTATC = 0.7;
    public static final boolean DEF_EML = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
        dic.put(InformationSet.item(prefix, EML), Boolean.class);
        dic.put(InformationSet.item(prefix, TYPES), String[].class);
        dic.put(InformationSet.item(prefix, VA), Double.class);
        dic.put(InformationSet.item(prefix, DELTATC), Double.class);
    }

    public OutlierSpec() {
        this.types_ = new ArrayList(4);
    }

    public void reset() {
        this.types_.clear();
        this.tc_ = 0.7;
        this.eml_ = false;
        this.cv_ = 0.0;
        this.span_ = new TsPeriodSelector();
    }

    public OutlierSpec clone() {
        try {
            OutlierSpec spec = (OutlierSpec)super.clone();
            spec.types_ = new ArrayList<OutlierType>(this.types_);
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public OutlierType[] getTypes() {
        if (this.types_.isEmpty()) {
            return null;
        }
        return Jdk6.Collections.toArray(this.types_, OutlierType.class);
    }

    public void setTypes(OutlierType[] types) {
        this.types_.clear();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.add(types[i]);
            }
        }
    }

    public void clearTypes() {
        this.types_.clear();
    }

    public boolean contains(OutlierType type) {
        return this.types_.contains(type);
    }

    public void add(OutlierType type) {
        if (!this.types_.contains(type)) {
            this.types_.add(type);
        }
    }

    public void addRange(Collection<OutlierType> types) {
        for (OutlierType t : types) {
            this.add(t);
        }
    }

    public double getDeltaTC() {
        return this.tc_;
    }

    public void setDeltaTC(double value) {
        if (value != 0.0 && value < 0.3 || value >= 1.0) {
            throw new TramoException("TC should belong to [0.3, 1.0[");
        }
        this.tc_ = value;
    }

    public double getCriticalValue() {
        return this.cv_;
    }

    public void setCriticalValue(double value) {
        if (value != 0.0 && value < 2.0) {
            throw new TramoException("Critical value should be not be smaller than 2.0");
        }
        this.cv_ = value;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public boolean isEML() {
        return this.eml_;
    }

    public void setEML(boolean value) {
        this.eml_ = value;
    }

    public int getAIO() {
        if (this.types_ == null) {
            return 0;
        }
        boolean ao = this.types_.contains(OutlierType.AO);
        boolean ls = this.types_.contains(OutlierType.LS);
        boolean tc = this.types_.contains(OutlierType.TC);
        if (ao && ls && !tc) {
            return 3;
        }
        if (ao && tc && !ls) {
            return 1;
        }
        return 2;
    }

    public void setAIO(int value) {
        this.clearTypes();
        switch (value) {
            case 1: {
                this.add(OutlierType.AO);
                this.add(OutlierType.TC);
                break;
            }
            case 2: {
                this.add(OutlierType.AO);
                this.add(OutlierType.TC);
                this.add(OutlierType.LS);
                break;
            }
            case 3: {
                this.add(OutlierType.AO);
                this.add(OutlierType.LS);
                break;
            }
        }
    }

    public boolean isDefault() {
        return !this.eml_ && this.cv_ == 0.0 && this.types_.isEmpty() && (this.span_ == null || this.span_.getType() == PeriodSelectorType.All) && this.tc_ == 0.7;
    }

    public boolean isUsed() {
        return !this.types_.isEmpty();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OutlierSpec && this.equals((OutlierSpec)obj);
    }

    private boolean equals(OutlierSpec other) {
        return this.cv_ == other.cv_ && this.eml_ == other.eml_ && Objects.equals(this.span_, other.span_) && this.tc_ == other.tc_ && Comparator.equals(this.types_, other.types_);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Jdk6.Double.hashCode(this.tc_);
        hash = 89 * hash + (this.eml_ ? 1 : 0);
        hash = 89 * hash + Jdk6.Double.hashCode(this.cv_);
        hash = 89 * hash + Objects.hashCode(this.span_);
        return hash;
    }

    public void remove(OutlierType outlierType) {
        this.types_.remove(outlierType);
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (!this.types_.isEmpty()) {
            String[] types = new String[this.types_.size()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.types_.get(i).name();
            }
            info.add(TYPES, types);
        }
        if (verbose || this.cv_ != 0.0) {
            info.add(VA, Double.valueOf(this.cv_));
        }
        if (verbose || this.eml_) {
            info.add(EML, Boolean.valueOf(this.eml_));
        }
        if (verbose || this.tc_ != 0.7) {
            info.add(DELTATC, Double.valueOf(this.tc_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean eml;
            Double tc;
            Double cv;
            String[] types;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((types = info.get(TYPES, String[].class)) != null) {
                for (int i = 0; i < types.length; ++i) {
                    this.types_.add(OutlierType.valueOf(types[i]));
                }
            }
            if ((cv = info.get(VA, Double.class)) != null) {
                this.cv_ = cv;
            }
            if ((tc = info.get(DELTATC, Double.class)) != null) {
                this.tc_ = tc;
            }
            if ((eml = info.get(EML, Boolean.class)) != null) {
                this.eml_ = eml;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

