/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.ssf.arima.SsfRwAr1;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

@Deprecated
public class Litterman {
    private TsData m_res;
    private TsData m_s;
    private TsData m_es;
    private TsAggregationType m_type = TsAggregationType.Sum;
    private boolean m_zinit;
    private boolean m_diffuseregs;
    private boolean m_ml = true;
    private boolean m_trend;
    private DiffuseConcentratedLikelihood m_ll;
    private double m_ro;
    private double m_stdero;
    private double m_precision = 1.0E-9;
    private IFunction m_fn;

    public boolean process(TsData y, TsFrequency freq, int nfcasts) {
        this.clear();
        int yfreq = y.getFrequency().intValue();
        int ifreq = freq.intValue();
        if (ifreq % yfreq != 0) {
            return false;
        }
        int conv = ifreq / yfreq;
        DisaggregationModel model = new DisaggregationModel(freq);
        model.setY(y);
        if (this.m_trend) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        model.setAggregationType(this.m_type);
        TsDisaggregation<SsfRwAr1> disagg = this.algorithm();
        disagg.useML(this.m_ml);
        TsDomain ndom = new TsDomain(freq, y.getStart().getYear(), y.getStart().getPosition() * conv, y.getLength() * conv + nfcasts);
        if (!disagg.process(model, ndom)) {
            return false;
        }
        this.analyse(disagg);
        return this.m_ll != null;
    }

    public boolean process(TsData y, TsVariableList x) {
        this.clear();
        if (x == null) {
            return false;
        }
        DisaggregationModel model = new DisaggregationModel(TsFrequency.Undefined);
        model.setY(y);
        if (this.m_trend) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        for (ITsVariable var : x.items()) {
            model.getX().add(var);
        }
        model.setAggregationType(this.m_type);
        int xfreq = x.getFrequency().intValue();
        int yfreq = y.getFrequency().intValue();
        if (xfreq == 0 || xfreq % yfreq != 0) {
            return false;
        }
        int conv = xfreq / yfreq;
        TsDisaggregation<SsfRwAr1> disagg = this.algorithm();
        if (!disagg.process(model, null)) {
            return false;
        }
        this.analyse(disagg);
        return this.m_ll != null;
    }

    private void analyse(TsDisaggregation<SsfRwAr1> disagg) {
        this.m_s = disagg.getSmoothedSeries();
        this.m_es = disagg.getSmoothedSeriesVariance().sqrt();
        this.m_ro = disagg.getEstimatedSsf().getRho();
        Matrix H = disagg.getObservedInformation();
        if (H != null) {
            this.m_stdero = Math.sqrt(1.0 / H.get(0, 0));
        }
        this.m_fn = disagg.getEstimationFunction();
        this.m_ll = disagg.getLikelihood();
        this.m_res = disagg.getFullResiduals();
    }

    private TsDisaggregation<SsfRwAr1> algorithm() {
        SsfRwAr1 rwar1 = new SsfRwAr1(-0.1);
        rwar1.useZeroInitialization(this.m_zinit);
        TsDisaggregation<SsfRwAr1> disagg = new TsDisaggregation<SsfRwAr1>();
        disagg.setSsf(rwar1);
        GridSearch gsearch = new GridSearch();
        gsearch.setPrecision(this.m_precision);
        disagg.setEpsilon(this.m_precision);
        disagg.setMinimizer(gsearch);
        disagg.setMapping(new SsfRwAr1.Mapping(this.m_zinit));
        disagg.calculateVariance(true);
        disagg.useML(this.m_ml);
        if (this.m_diffuseregs) {
            disagg.setDiffuseRegressorsCount(-1);
        }
        return disagg;
    }

    private void clear() {
        this.m_s = null;
        this.m_es = null;
        this.m_ll = null;
        this.m_fn = null;
    }

    public boolean isTrend() {
        return this.m_trend;
    }

    public void setTrend(boolean value) {
        this.m_trend = value;
    }

    public double getPrecision() {
        return this.m_precision;
    }

    public void setPrecision(double value) {
        this.m_precision = value;
    }

    public boolean isML() {
        return this.m_ml;
    }

    public void setML(boolean value) {
        this.m_ml = value;
    }

    public TsAggregationType getAggregationType() {
        return this.m_type;
    }

    public void setAggregationType(TsAggregationType value) {
        this.m_type = value;
    }

    public boolean isZeroInitialization() {
        return this.m_zinit;
    }

    public void setZeroInitialization(boolean value) {
        this.m_zinit = value;
    }

    public boolean isDiffuseRegressionCoefficients() {
        return this.m_diffuseregs;
    }

    public void setDiffuseRegressionCoefficients(boolean value) {
        this.m_diffuseregs = value;
    }

    public double getRo() {
        return this.m_ro;
    }

    public double getStdeRo() {
        return this.m_stdero;
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        if (this.m_ll == null) {
            return null;
        }
        LikelihoodStatistics stats = LikelihoodStatistics.create(this.m_ll, this.m_ll.getN(), 1, 0.0);
        return stats;
    }

    public TsData getResiduals() {
        return this.m_res;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.m_ll;
    }

    public IFunction getLikelihoodFunction() {
        return this.m_fn;
    }

    public TsData getDisaggregatedSeries() {
        return this.m_s;
    }

    public TsData getDisaggregatedSeriesStde() {
        return this.m_es;
    }
}

