/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.TramoModelEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class FinalEstimator
implements IModelEstimator {
    private double cancel_ = 0.044;
    private double tsig_ = 1.0;
    private double ur_ = 0.96;
    private double eps_ = 1.0E-4;
    private static final int MAXD = 2;
    private static final int MAXBD = 1;
    private int pass_ = 0;
    private int nnsig_;

    public void setPass(int pass) {
        this.pass_ = pass;
    }

    public int getChangedParametersCount() {
        return this.nnsig_;
    }

    @Override
    public boolean estimate(ModellingContext context) {
        int niter = 0;
        do {
            try {
                IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
                ModelDescription model = context.description;
                context.estimation = new ModelEstimation(model.buildRegArima(), model.getLikelihoodCorrection());
                int ndim = mapping.getDim();
                TramoModelEstimator monitor = new TramoModelEstimator(mapping);
                monitor.setPrecision(this.getEpsilon());
                if (context.description.isPartiallySpecified()) {
                    context.estimation.improve(monitor, ndim);
                } else {
                    context.estimation.compute(monitor, ndim);
                }
                context.estimation.updateParametersCovariance(monitor.getParametersCovariance());
                if (ndim == 0) {
                    return true;
                }
                context.information.subSet("optimization").set("score", monitor.getScore());
                if (this.checkUnitRoots(context)) {
                    this.nnsig_ = 0;
                    if (context.automodelling) {
                        this.nnsig_ = !this.checkCommonRoots(context) ? 2 : this.test(context);
                    }
                    if (this.nnsig_ == 0) {
                        return true;
                    }
                    if (this.nnsig_ != 1 && context.outliers && this.pass_ <= 1) {
                        return false;
                    }
                }
            }
            catch (RuntimeException err) {
                return false;
            }
        } while (niter++ < 5);
        return false;
    }

    private int test(ModellingContext context) {
        int nnsig;
        double t;
        double s;
        double v;
        double cval = this.getTsig();
        int nz = context.description.getEstimationDomain().getLength();
        double cmin = nz <= 150 ? 0.15 : 0.1;
        double cmod = 0.95;
        SarimaModel m = context.estimation.getRegArima().getArima();
        SarimaSpecification spec = m.getSpecification();
        IReadDataBlock pm = m.getParameters();
        int icpr = 0;
        int icps = 0;
        int icqr = 0;
        int icqs = 0;
        double bmin = 99999.0;
        int k = -1;
        double tmin = cval;
        DataBlock diag = context.estimation.getParametersCovariance().diagonal();
        k += spec.getP();
        if (spec.getP() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin) {
                icpr = 1;
                bmin = t;
            }
        }
        k += spec.getBP();
        if (spec.getBP() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                bmin = t;
                icps = 1;
                icpr = 0;
            }
        }
        k += spec.getQ();
        if (spec.getQ() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                bmin = t;
                icqr = 1;
                icpr = 0;
                icps = 0;
            }
        }
        k += spec.getBQ();
        if (spec.getBQ() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                icqs = 1;
                icpr = 0;
                icps = 0;
                icqr = 0;
            }
        }
        if ((nnsig = icpr + icps + icqr + icqs) == 0) {
            return 0;
        }
        SarimaSpecification nspec = spec.clone();
        if (icpr > 0) {
            nspec.setP(nspec.getP() - 1);
        }
        if (icps > 0) {
            nspec.setBP(nspec.getBP() - 1);
        }
        if (icqr > 0) {
            nspec.setQ(nspec.getQ() - 1);
        }
        if (icqs > 0) {
            nspec.setBQ(nspec.getBQ() - 1);
        }
        context.description.setSpecification(nspec);
        context.estimation = null;
        return nnsig;
    }

    private boolean checkCommonRoots(ModellingContext context) {
        SarimaModel arima = context.estimation.getArima();
        SarimaSpecification spec = arima.getSpecification();
        boolean changed = false;
        if (spec.getP() != 0 && spec.getQ() != 0) {
            int i;
            Polynomial p = arima.getRegularAR();
            Polynomial q = arima.getRegularMA();
            Complex[] pr = p.roots();
            Complex[] qr = q.roots();
            for (i = 0; i < pr.length; ++i) {
                pr[i] = pr[i].inv();
            }
            for (i = 0; i < qr.length; ++i) {
                qr[i] = qr[i].inv();
            }
            Complex.SimplifyingTool tool = new Complex.SimplifyingTool(this.getCancel());
            if (tool.simplify(pr, qr)) {
                spec.setP(spec.getP() - 1);
                spec.setQ(spec.getQ() - 1);
                changed = true;
            }
        }
        if (spec.getBP() == 1 && spec.getBQ() == 1 && Math.abs(arima.bphi(1) - arima.btheta(1)) < this.getCancel()) {
            spec.setBP(0);
            spec.setBQ(0);
            changed = true;
        }
        if (changed) {
            context.description.setSpecification(spec);
            context.estimation = null;
            return false;
        }
        return true;
    }

    private boolean checkUnitRoots(ModellingContext context) {
        SarimaModel m = context.estimation.getArima();
        SarimaSpecification nspec = m.getSpecification();
        boolean ok = true;
        if (nspec.getP() > 0 && nspec.getD() < 2 && 0 != this.searchur(m.getRegularAR().mirror().roots())) {
            nspec.setP(nspec.getP() - 1);
            nspec.setD(nspec.getD() + 1);
            ok = false;
        }
        if (nspec.getBP() > 0 && nspec.getBD() < 1 && 0 != this.searchur(m.getSeasonalAR().mirror().roots())) {
            nspec.setBP(nspec.getBP() - 1);
            nspec.setBD(nspec.getBD() + 1);
            ok = false;
        }
        if (ok) {
            return true;
        }
        context.description.setSpecification(nspec);
        context.estimation = null;
        return false;
    }

    private int searchur(Complex[] r) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (!(vcur > this.getUr()) || !(cdim <= 0.05) || !(r[i].getRe() > 0.0)) continue;
            ++n;
        }
        return n;
    }

    public double getCancel() {
        return this.cancel_;
    }

    public void setCancel(double cancel) {
        this.cancel_ = cancel;
    }

    public double getTsig() {
        return this.tsig_;
    }

    public void setTsig(double tsig) {
        this.tsig_ = tsig;
    }

    public double getUr() {
        return this.ur_;
    }

    public void setUr(double ur) {
        this.ur_ = ur;
    }

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double eps) {
        this.eps_ = eps;
    }
}

