/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataStructureParser {
    private static final String sourceClass = DataStructureParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String DATASTRUCTURE = "DataStructure";
    static final String CODELISTS = "Codelists";
    static final String CODELIST = "Codelist";
    static final String CONCEPTS = "Concepts";
    static final String CONCEPT = "Concept";
    static final String NAME = "Name";
    static final String DIMENSIONLIST = "DimensionList";
    static final String GROUP = "Group";
    static final String ATTRIBUTELIST = "AttributeList";
    static final String MEASURELIST = "MeasureList";
    static final String DIMENSION = "Dimension";
    static final String TIMEDIMENSION = "TimeDimension";
    static final String POSITION = "position";
    static final String ID = "id";
    static final String AGENCYID = "agencyID";
    static final String VERSION = "version";
    static final String LOCAL_REPRESENTATION = "LocalRepresentation";
    static final String REF = "Ref";

    public static List<DataFlowStructure> parse(Reader reader) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(reader);
        ArrayList<DataFlowStructure> arrayList = new ArrayList<DataFlowStructure>();
        Map<String, Map<String, String>> map = null;
        Map<String, String> map2 = null;
        DataFlowStructure dataFlowStructure = null;
        LocalizedText localizedText = new LocalizedText(Configuration.getLang());
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == CODELISTS) {
                    map = DataStructureParser.getCodelists(xMLEventReader);
                } else if (startElement.getName().getLocalPart() == CONCEPTS) {
                    map2 = DataStructureParser.getConcepts(xMLEventReader);
                }
                if (startElement.getName().getLocalPart() == DATASTRUCTURE) {
                    dataFlowStructure = new DataFlowStructure();
                    localizedText.clear();
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string = attribute.getValue();
                            dataFlowStructure.setId(string);
                            continue;
                        }
                        if (attribute.getName().toString().equals(AGENCYID)) {
                            string2 = attribute.getValue();
                            dataFlowStructure.setAgency(string2);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(VERSION)) continue;
                        string3 = attribute.getValue();
                        dataFlowStructure.setVersion(string3);
                    }
                    logger.finer("Got data structure.");
                }
                if (startElement.getName().getLocalPart().equals(NAME) && dataFlowStructure != null) {
                    localizedText.setText(startElement, xMLEventReader);
                }
                if (startElement.getName().getLocalPart().equals(DIMENSIONLIST)) {
                    if (dataFlowStructure != null) {
                        DataStructureParser.setStructureDimensions(dataFlowStructure, xMLEventReader, map, map2);
                    } else {
                        throw new RuntimeException("Error during Structure Parsing. Null current structure.");
                    }
                }
                if (startElement.getName().getLocalPart().equals(GROUP)) {
                    DataStructureParser.setStructureGroups(dataFlowStructure, xMLEventReader);
                }
                if (startElement.getName().getLocalPart().equals(ATTRIBUTELIST)) {
                    DataStructureParser.setStructureAttributes(dataFlowStructure, xMLEventReader);
                }
                if (startElement.getName().getLocalPart().equals(MEASURELIST)) {
                    DataStructureParser.setStructureMeasures(dataFlowStructure, xMLEventReader);
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(DATASTRUCTURE)) continue;
            logger.finer("Adding data structure. " + dataFlowStructure);
            dataFlowStructure.setName(localizedText.getText());
            arrayList.add(dataFlowStructure);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setStructureDimensions(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Map<String, String>> map, Map<String, String> map2) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureDimensions");
        Dimension dimension = null;
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Attribute attribute;
                Object object;
                Object object2;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(DIMENSION)) {
                    logger.finer("Got dimension");
                    dimension = new Dimension();
                    dimension.setPosition(++n);
                    object2 = startElement.getAttributes();
                    object = null;
                    while (object2.hasNext()) {
                        attribute = object2.next();
                        if (!attribute.getName().toString().equals(ID)) continue;
                        object = attribute.getValue();
                    }
                    if (object == null || ((String)object).isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid id: " + (String)object);
                    dimension.setId((String)object);
                } else {
                    if (startElement.getName().getLocalPart().equals(TIMEDIMENSION)) {
                        logger.finer("Got time dimension");
                        object2 = startElement.getAttributes();
                        object = null;
                        while (object2.hasNext()) {
                            attribute = object2.next();
                            if (!attribute.getName().toString().equals(ID)) continue;
                            object = attribute.getValue();
                        }
                        if (object == null || ((String)object).isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + (String)object);
                        if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                        logger.finer("Adding time dimension: " + (String)object);
                        dataFlowStructure.setTimeDimension((String)object);
                        continue;
                    }
                    if (startElement.getName().getLocalPart().equals(LOCAL_REPRESENTATION)) {
                        logger.finer("Got time codelist");
                        DataStructureParser.setCodelistName(dimension, xMLEventReader);
                        if (map != null) {
                            object2 = dimension.getCodeList();
                            object = map.get(((Codelist)object2).getFullIdentifier());
                            ((Codelist)object2).setCodes((Map<String, String>)object);
                        }
                    } else if (startElement.getName().getLocalPart().equals("ConceptIdentity")) {
                        logger.finer("Got concept identity");
                        if (map2 != null) {
                            dimension.setName(DataStructureParser.getConceptName(map2, xMLEventReader));
                        }
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSION)) {
                if (dataFlowStructure == null || dimension == null) throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
                logger.finer("Adding dimension: " + dimension);
                dataFlowStructure.setDimension(dimension);
                continue;
            }
            if (!xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSIONLIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureDimensions");
    }

    private static void setCodelistName(Dimension dimension, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setCodelist");
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(REF)) {
                Object object;
                logger.finer("Got codelist");
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = "";
                String string3 = "";
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.getName().toString().equals(ID)) {
                        string = object.getValue();
                        continue;
                    }
                    if (object.getName().toString().equals(AGENCYID)) {
                        string3 = object.getValue();
                        continue;
                    }
                    if (!object.getName().toString().equals(VERSION)) continue;
                    string2 = object.getValue();
                }
                if (string != null && !string.isEmpty()) {
                    if (dimension != null) {
                        object = new Codelist(string, string3, string2);
                        logger.finer("Adding codelist: " + ((Codelist)object).getFullIdentifier());
                        dimension.setCodeList((Codelist)object);
                        continue;
                    }
                    throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                }
                throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + string);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(LOCAL_REPRESENTATION)) continue;
            break;
        }
        logger.exiting(sourceClass, "setCodelist");
    }

    private static void setStructureGroups(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureGroups");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(GROUP)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureGroups");
    }

    private static void setStructureMeasures(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureMeasures");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(MEASURELIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureMeasures");
    }

    private static void setStructureAttributes(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureAttributes");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(ATTRIBUTELIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureAttributes");
    }

    private static Map<String, Map<String, String>> getCodelists(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        Hashtable<String, Map<String, String>> hashtable = new Hashtable<String, Map<String, String>>();
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(CODELIST)) {
                Object object;
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = "";
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.getName().toString().equals(ID)) {
                        string = object.getValue();
                        continue;
                    }
                    if (object.getName().toString().equals(AGENCYID)) {
                        string2 = object.getValue();
                        continue;
                    }
                    if (!object.getName().toString().equals(VERSION)) continue;
                    string3 = object.getValue();
                }
                string4 = string2 + "/" + string + "/" + string3;
                logger.finer("Got codelist: " + string4);
                object = CodelistParser.getCodes(xMLEventReader);
                hashtable.put(string4, (Map<String, String>)object);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CODELISTS)) continue;
            break;
        }
        return hashtable;
    }

    private static Map<String, String> getConcepts(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = "";
        String string2 = "";
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Iterator<Attribute> iterator;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals("ConceptScheme")) {
                    iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (object.getName().toString().equals(AGENCYID)) {
                            string = object.getValue();
                            continue;
                        }
                        if (!object.getName().toString().equals(VERSION)) continue;
                        string2 = object.getValue();
                    }
                } else if (startElement.getName().getLocalPart().equals(CONCEPT)) {
                    iterator = startElement.getAttributes();
                    object = null;
                    String string3 = "";
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.getName().toString().equals(ID)) continue;
                        object = attribute.getValue();
                    }
                    string3 = string + "/" + (String)object + "/" + string2;
                    logger.finer("Got concept: " + string3);
                    hashtable.put(string3, DataStructureParser.getConceptName(xMLEventReader));
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CONCEPTS)) continue;
            break;
        }
        return hashtable;
    }

    private static String getConceptName(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        LocalizedText localizedText = new LocalizedText(Configuration.getLang());
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (object = xMLEvent.asStartElement()).getName().getLocalPart() == NAME) {
                localizedText.setText((StartElement)object, xMLEventReader);
            }
            if (!xMLEvent.isEndElement() || !((String)(object = xMLEvent.asEndElement().getName().getLocalPart())).equals(CONCEPT)) continue;
            break;
        }
        return localizedText.getText();
    }

    private static String getConceptName(Map<String, String> map, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (object = xMLEvent.asStartElement()).getName().getLocalPart() == REF) {
                Iterator<Attribute> iterator = object.getAttributes();
                String string2 = null;
                String string3 = "";
                String string4 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        string2 = attribute.getValue();
                        continue;
                    }
                    if (attribute.getName().toString().equals(AGENCYID)) {
                        string4 = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals("maintainableParentVersion")) continue;
                    string3 = attribute.getValue();
                }
                string = map.get(string4 + "/" + string2 + "/" + string3);
            }
            if (!xMLEvent.isEndElement() || !((String)(object = xMLEvent.asEndElement().getName().getLocalPart())).equals("ConceptIdentity")) continue;
            break;
        }
        return string;
    }
}

