/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.event.RestSdmxEventListener;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxIOException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLInputFactory;

public class RestSdmxClient
implements GenericSDMXClient {
    private static final String sourceClass = RestSdmxClient.class.getSimpleName();
    protected static final Logger logger = Configuration.getSdmxLogger();
    protected String name;
    protected final boolean needsURLEncoding;
    protected final boolean supportsCompression;
    protected SSLSocketFactory sslSocketFactory;
    protected final boolean dotStat = false;
    protected URI endpoint;
    protected boolean needsCredentials = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    protected int readTimeout;
    protected int connectTimeout;
    protected LanguagePriorityList languages;
    protected RestSdmxEventListener dataFooterMessageEventListener = RestSdmxEventListener.NO_OP_LISTENER;
    protected RestSdmxEventListener redirectionEventListener = RestSdmxEventListener.NO_OP_LISTENER;

    public RestSdmxClient(String string, URI uRI, SSLSocketFactory sSLSocketFactory, boolean bl, boolean bl2, boolean bl3) {
        this.endpoint = uRI;
        this.name = string;
        this.needsCredentials = bl;
        this.needsURLEncoding = bl2;
        this.supportsCompression = bl3;
        this.sslSocketFactory = sSLSocketFactory;
        this.readTimeout = Configuration.getReadTimeout(this.getClass().getSimpleName());
        this.connectTimeout = Configuration.getConnectTimeout(this.getClass().getSimpleName());
        this.languages = LanguagePriorityList.parse(Configuration.getLang());
    }

    public RestSdmxClient(String string, URI uRI, boolean bl, boolean bl2, boolean bl3) {
        this(string, uRI, null, bl, bl2, bl3);
    }

    public void setSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setLanguages(LanguagePriorityList languagePriorityList) {
        this.languages = languagePriorityList;
    }

    public void setDataFooterMessageEventListener(RestSdmxEventListener restSdmxEventListener) {
        this.dataFooterMessageEventListener = restSdmxEventListener;
    }

    public void setRedirectionEventListener(RestSdmxEventListener restSdmxEventListener) {
        this.redirectionEventListener = restSdmxEventListener;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap = null;
        URL uRL = this.buildFlowQuery("all", "all", "latest");
        List<Dataflow> list = this.runQuery(new DataflowParser(), uRL, null, "dataflow_all");
        if (list.size() > 0) {
            hashMap = new HashMap<String, Dataflow>();
            for (Dataflow dataflow : list) {
                hashMap.put(dataflow.getFullIdentifier(), dataflow);
            }
        } else {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow = null;
        URL uRL = this.buildFlowQuery(string, string2, string3);
        List<Dataflow> list = this.runQuery(new DataflowParser(), uRL, null, "dataflow_" + string);
        if (list.size() < 1) {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        dataflow = list.get(0);
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        if (dSDIdentifier == null) {
            throw new SdmxInvalidParameterException("getDataFlowStructure(): Null dsd in input");
        }
        URL uRL = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
        return this.runQuery(new DataStructureParser(), uRL, null, "datastructure_" + dSDIdentifier.getId()).get(0);
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildCodelistQuery(string, string2, string3);
        return this.runQuery(new CodelistParser(), uRL, null, "codelist_" + string);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2));
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        String string5;
        URL uRL;
        DataParsingResult dataParsingResult = this.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl), uRL = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2), "application/vnd.sdmx.structurespecificdata+xml;version=2.1", string5 = "data_" + dataflow.getId() + "_" + string);
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            logger.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent(uRL, message);
            this.dataFooterMessageEventListener.onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(URI uRI) {
        this.endpoint = uRI;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String buildDataURL(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2).toString();
    }

    /*
     * Exception decompiling
     */
    protected final <T> T runQuery(Parser<T> var1_1, URL var2_2, String var3_3, String var4_4) throws SdmxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleHttpHeaders(HttpURLConnection httpURLConnection, String string) {
        if (this.containsCredentials) {
            logger.fine("Setting http authorization");
            String string2 = DatatypeConverter.printBase64Binary((byte[])(this.user + ":" + this.pw).getBytes());
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        }
        if (this.supportsCompression) {
            httpURLConnection.addRequestProperty("Accept-Encoding", "gzip,deflate");
        }
        if (this.languages != null) {
            httpURLConnection.addRequestProperty("Accept-Language", this.languages.toString());
        }
        if (string != null && !"".equals(string)) {
            httpURLConnection.setRequestProperty("Accept", string);
        } else {
            httpURLConnection.setRequestProperty("Accept", "*/*");
        }
    }

    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, null).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }

    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createStructureQuery(this.endpoint, string, string2, string3, bl).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.endpoint);
    }

    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx21Queries.createDataflowQuery(this.endpoint, string, string2, string3).buildSdmx21Query();
    }

    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx21Queries.createCodelistQuery(this.endpoint, string, string2, string3).buildSdmx21Query();
    }

    private static boolean isRedirection(int n) {
        return n >= 300 && n <= 303 || n == 307;
    }

    private static URL getRedirectionURL(URLConnection uRLConnection, int n) throws SdmxIOException {
        String string = uRLConnection.getHeaderField("Location");
        if (string == null || string.isEmpty()) {
            throw new SdmxIOException("The endpoint returned redirect code: " + n + ", but the location was empty.", null);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdmxIOException("The endpoint returned redirect code: " + n + ", but the location was malformed: '" + string + "'.", null);
        }
    }

    public BufferedReader skipBOM(Reader reader) throws SdmxException {
        BufferedReader bufferedReader = new BufferedReader(reader){

            @Override
            public void close() throws IOException {
                logger.fine("GenericDataParser::skipBOM: closing stream.");
                super.close();
            }
        };
        try {
            char[] cArray = new char[1];
            bufferedReader.mark(1);
            bufferedReader.read(cArray, 0, 1);
            logger.fine(String.format("0x%2s", Integer.toHexString(cArray[0])));
            if ((byte)cArray[0] == -1) {
                logger.fine("BOM found and skipped");
            } else {
                logger.fine("GenericDataParser::skipBOM: Resetting stream.");
                bufferedReader.reset();
            }
        }
        catch (IOException iOException) {
            throw SdmxExceptionFactory.wrap(iOException);
        }
        return bufferedReader;
    }

    private static void preventXXE(XMLInputFactory xMLInputFactory) {
        if (xMLInputFactory.isPropertySupported("javax.xml.stream.supportDTD")) {
            xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (xMLInputFactory.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
    }

    protected List<PortableTimeSeries<Double>> postProcess(DataParsingResult dataParsingResult) {
        return dataParsingResult;
    }
}

