/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class HelperHandler
extends Handler {
    public static final String LOG_FORMAT = "\u00e2\u008f\u00b0 %1$s [%2$s:%3$s] %4$s%5$s%n";
    private static final Formatter FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord logRecord) {
            Object object;
            String string = this.formatMessage(logRecord);
            String string2 = "";
            if (logRecord.getThrown() != null) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                printWriter.println();
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                string2 = ((StringWriter)object).toString();
            }
            object = logRecord.getSourceClassName();
            int n = ((String)object).length() - ((String)object).replace(".", "").length() - 1;
            for (int i = 0; i < n; ++i) {
                object = ((String)object).replaceFirst("([A-Za-z_])[^.]+\\.", "$1.");
            }
            return String.format(HelperHandler.LOG_FORMAT, logRecord.getLevel().getName(), object, logRecord.getSourceMethodName(), string, string2);
        }
    };
    private final JTextPane loggingArea;
    private final Deque<Position> positions = new LinkedList<Position>();

    public HelperHandler(JTextPane jTextPane) {
        this.loggingArea = jTextPane;
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        int n = this.loggingArea.getDocument().getLength();
        String string = FORMATTER.format(logRecord);
        StyledDocument styledDocument = (StyledDocument)this.loggingArea.getDocument();
        try {
            styledDocument.insertString(n, string, null);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (logRecord.getLevel() == Level.SEVERE || logRecord.getLevel() == Level.WARNING) {
                StyleConstants.setForeground(simpleAttributeSet, new Color(255, 0, 0));
            }
            styledDocument.setCharacterAttributes(n, string.length(), simpleAttributeSet, false);
            simpleAttributeSet.addAttribute("TIME", new Date());
            styledDocument.setCharacterAttributes(n, 1, simpleAttributeSet, true);
            this.positions.add(styledDocument.createPosition(styledDocument.getEndPosition().getOffset()));
            if (string.contains("http://") || string.contains("https://")) {
                int n2 = string.indexOf("http://");
                if (n2 == -1) {
                    n2 = string.indexOf("https://");
                }
                int n3 = string.substring(n2).split("\\s", 2)[0].length() + n2;
                simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute("URL", string.substring(n2, n3));
                StyleConstants.setUnderline(simpleAttributeSet, true);
                StyleConstants.setForeground(simpleAttributeSet, Color.BLUE);
                styledDocument.setCharacterAttributes(n + n2, n3 - n2, simpleAttributeSet, true);
            }
            while (this.positions.size() > 0 && styledDocument.getLength() > 50000) {
                styledDocument.remove(0, this.positions.remove().getOffset());
            }
            this.loggingArea.setCaretPosition(this.loggingArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

