% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotRsmOperatingCharacteristics.R
\name{PlotRsmOperatingCharacteristics}
\alias{PlotRsmOperatingCharacteristics}
\title{RSM predicted operating characteristics, ROC pdfs and different FOMs
   possible with FROC data}
\usage{
PlotRsmOperatingCharacteristics(mu, lambda, nu, lesDistr, lesionWeights,
  type = "ALL", legendPosition = c(1, 0),
  legendDirection = "horizontal", legendJustification = c(0, 1),
  nlfRange = NULL, llfRange = NULL, nlfAlpha = NULL, myNegInf = -3)
}
\arguments{
\item{mu}{Array, max length 2. The mean(s) of the Gaussian distribution(s) for the 
ratings of latent LLs (continuous ratings of lesions that are found by the 
observer's search mechanism)}

\item{lambda}{Array, max length 2. The Poisson distribution \emph{intrinsic} 
parameter(s), which model the random numbers of latent NLs (suspicious 
regions that do not correspond to actual lesions) per case, for up to two 
treatments. The corresponding \emph{physical} parameters are \code{lambda/mu}. 
Two conversion functions are provided: \code{\link{UtilIntrinsic2PhysicalRSM}} and 
\code{\link{UtilPhysical2IntrinsicRSM}}.}

\item{nu}{Array, max length 2. The binomial distribution success probability 
\emph{intrinsic} parameters, which model the random numbers of latent LLs 
(suspicious regions that 
correspond to actual lesions) per diseased case for up to two treatments; 
the corresponding \emph{physical} parameter is \code{1 - exp(nu*mu)}, 
the success probability of the binomial distribution(s).}

\item{lesDistr}{Array, [1:maxLL,1:2]. The probability mass function of the 
lesion distribution for diseased cases. The first column contains the 
actual numbers of lesions per case. 
The second column contains the fraction of diseased cases with the number 
of lesions specified in the first column. 
The second column must sum to unity.}

\item{lesionWeights}{Array, [1:maxLL,1:maxLL]. The weights (or clinical importances) 
of the lesions. The 1st row contains the weight of the lesion on cases
with one lesion only, necessarily 1; the remaining elements of the row are 
\code{-Inf}. The 2nd row contains the weights of the 2 lesions on cases with 
2 lesions only, the remaining elements of the row, if any, are \code{-Inf}. 
Excluding the \code{-Inf}, each row must sum to 1. 
The default is equal weighting, e.g., weights are 1/3, 1/3, 1/3 on row 3.
This parameter is not to be confused with the lesionWeights field in an FROC
dataset with enumerates the weights of lesions on individual cases.}

\item{type}{The type of operating characteristic desired: can be "\code{ROC}", 
"\code{AFROC}", "\code{wAFROC}", "\code{FROC}" or "\code{pdfs}" or "\code{ALL}". 
The default is "\code{ALL}".}

\item{legendPosition}{The positioning of the legend: "\code{right}", "\code{left}", 
"\code{top}" or "\code{bottom}". Use "\code{none}" to suppress the legend.}

\item{legendDirection}{Allows control on the direction of the legend; 
\code{"horizontal"}, the default, or \code{"vertical"}}

\item{legendJustification}{Where to position the legend, default 
is bottom right corner c(0,1)}

\item{nlfRange}{\bold{This applies to FROC plot only}. The x-axis range, e.g., c(0,2), 
for FROC plot. Default is "\code{NULL}", which means the maximum NLF range, 
as determined by the data.}

\item{llfRange}{\bold{This applies to FROC plot only}. The y-axis range, e.g., c(0,1), 
for FROC plot. Default is "\code{NULL}", which means the maximum LLF range,
as determined by the data.}

\item{nlfAlpha}{Upper limit of the integrated area under the FROC plot. 
Default is "\code{NULL}", which means the maximum NLF range is used 
(i.e., lambda/mu). Attempt to integrate outside the maximum NLF will 
generate an error.}

\item{myNegInf}{How close one approaches the end-point; the default is -3. 
This is used in the code to demonstrate continuity of the slope of the 
ROC at the end point; Online Appendix 17.H.3}
}
\value{
A list of 6 elements containing six \pkg{ggplot2} objects 
   (ROCPlot, AFROCPlot wAFROCPlot, FROCPlot and PDFPlot) and two area measures 
   (each of which can have up to two elements), the area under the search 
   model predicted ROC curves in up to two treatments, the area under the search 
   model predicted AFROC curves in up to two treatments, the area under the 
   search model predicted wAFROC curves in up to two treatments, the area under 
   the search model predicted FROC curves in up to two treatments.
\itemize{
\item{\code{ROCPlot}}   {The predicted ROC plots}
\item{\code{AFROCPlot}}     {The predicted AFROC plots}
\item{\code{wAFROCPlot}}    {The predicted wAFROC plots}
\item{\code{FROCPlot}}  {The predicted FROC plots}
\item{\code{PDFPlot}}   {The predicted pdf plots}
\item{\code{aucROC}}    {The predicted ROC AUCs}
\item{\code{aucAFROC}}  {The predicted AFROC AUCs}
\item{\code{aucwAFROC}} {The predicted wAFROC AUCs}
\item{\code{aucFROC}}   {The predicted FROC AUCs}
}
}
\description{
Visualize predicted ROCs, AFROCs, wAFROCs, FROCs and pdfs 
   (probability density functions of highest ratings, 
   for non-diseased and diseased cases), for up to 2 sets of search model parameters.
   This function is useful as an instructional tool towards understanding the RSM.
}
\details{
RSM is the Radiological Search Model described in the book.
}
\note{
For \code{lesDistr}, the sum over the second column must equal one. 
   If all cases contain same number of lesions, simply supply this number instead of 
   the matrix. If the argument is missing, the default value 
   of one lesion per diseased case applies. 
  
In \code{lesionWeights}, the sum over each row (excluding \code{-Inf}) must be one. 
   The value \code{-Inf} should be assigned if the corresponding lesion 
   does not exist. Equal lesion weighting is applied if this argument is missing.

   For example, if the maximum number of distinct lesion configurations per case 
   is 3 (e.g., 1, 2 and 4, implying there are no cases with 3 lesions), the 
   first column of \code{lesDistr} will be c(1,2,4). The second column might be
   c(0.8, 0.15, 0.05), which sums to one, meaning 80\% of cases have only one 
   lesion, 15\% have two lesions and 5\% have three lesions. The 
   \code{lesionWeights} matrix will be 
   \code{[1:3,1:3]}, where each row will sum to one (excluding negative infinities).
}
\examples{
## Following example is for mu = 2, lambda = 1, nu = 0.6, in one treatment and   
## mu = 3, lambda = 1.5, nu = 0.8, in the other treatment. 20\% of the diseased 
## cases have a single lesion, 40\% have two lesions, 10\% have 3 lesions, 
## and 30\% have 4 lesions.  
lesDistr <- rbind(c(1, 0.2), c(2, 0.4), c(3, 0.1), c(4, 0.3))

## On cases with one lesion the weights are 1, on cases with 2 lesions the weights
## are 0.4 and 0.6, on cases with three lesions the weights are 0.2, 0.3 and 0.5, and
## on cases with 4 lesions the weights are 0.3, 0.4, 0.2 and 0.1: 
lesionWeights <- rbind(c(1.0, -Inf, -Inf, -Inf), 
                       c(0.4,  0.6, -Inf, -Inf), 
                       c(0.2,  0.3,  0.5, -Inf), 
                       c(0.3,  0.4, 0.2,  0.1))
ret <- PlotRsmOperatingCharacteristics(mu = c(2, 3), lambda = c(1, 1.5), nu = c(0.6, 0.8),
   lesDistr = lesDistr, lesionWeights = lesionWeights, 
   legendPosition = "bottom", nlfRange = c(0, 1), llfRange = c(0, 1))
   print(ret$ROCPlot)
   print(ret$AFROCPlot)
   print(ret$wAFROCPlot)
   print(ret$FROCPlot)
## the FROC plot ends at NLF = 0.5 because for both treatments the physical lambdas are 0.5.

}
\references{
Chakraborty DP (2006) A search model and figure of merit for observer data acquired according to the free-response 
paradigm, Phys Med Biol 51, 3449-3462.

Chakraborty DP (2006) ROC Curves predicted by a model of visual search, Phys Med Biol 51, 3463--3482.

Chakraborty, DP, Yoon, HJ (2008) Operating characteristics predicted by models for diagnostic tasks involving lesion localization, Med Phys, 35:2, 435.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples} (CRC Press, Boca Raton, FL). 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
