% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilDBM2ORVarCom.R
\name{UtilDBM2ORVarCom}
\alias{UtilDBM2ORVarCom}
\title{Convert from DBM to OR variance components}
\usage{
UtilDBM2ORVarCom(K, DBMVarCom)
}
\arguments{
\item{K}{Total number of cases}

\item{DBMVarCom}{DBM variance components, a data.frame 
containing VarR, VarC, VarTR, VarTC, VarRC and VarErr}
}
\value{
\code{UtilDBM2ORVarCom} returns the equivalent OR Variance components
}
\description{
\code{UtilDBM2ORVarCom} converts from DBM variance components to OR 
   variance components
}
\examples{
DBMVarCom <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "DBM")$ANOVA$VarCom
UtilDBM2ORVarCom(114, DBMVarCom)

ORVarCom <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "OR")$ANOVA$VarCom
UtilOR2DBMVarCom(114, ORVarCom)


}
