/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleFillersTranslator
extends DIGQueryTranslator {
    public DIGQueryRoleFillersTranslator() {
        super(null, null, "*");
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query2, "roleFillers");
        da.addNamedElement(instances, "individual", da.getNodeID(pattern.getSubject()));
        da.addNamedElement(instances, "ratom", da.getNodeID(pattern.getPredicate()));
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.translateIndividualSetResponse(response, query2, true);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return null;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return subject.isConcrete() && da.isIndividual(subject);
    }

    public boolean checkPredicate(Node predicate, DIGAdapter da, Model premises) {
        if (predicate.isConcrete()) {
            Resource p = (Resource)da.m_sourceData.getRDFNode(predicate);
            String pNS = p.getNameSpace();
            return !da.m_sourceData.contains(p, RDF.type, da.m_sourceData.getProfile().DATATYPE_PROPERTY()) && !RDFS.getURI().equals(pNS) && !RDF.getURI().equals(pNS) && !OWL.getURI().equals(pNS);
        }
        return false;
    }
}

