/*
 * Decompiled with CFR 0.152.
 */
package kea.stemmers;

import kea.stemmers.Stemmer;

public class PorterStemmer
extends Stemmer {
    private static final long serialVersionUID = 1L;

    public String stem(String str) {
        if (str.length() > 3) {
            char[] c = str.toCharArray();
            int i = 0;
            while (i < c.length) {
                if (!Character.isLetter(c[i])) {
                    return str.toLowerCase();
                }
                ++i;
            }
        } else {
            return str.toLowerCase();
        }
        str = this.step1a(str);
        str = this.step1b(str);
        str = this.step1c(str);
        str = this.step2(str);
        str = this.step3(str);
        str = this.step4(str);
        str = this.step5a(str);
        str = this.step5b(str);
        return str.toLowerCase();
    }

    protected String step1a(String str) {
        if (str.endsWith("sses")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ies")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ss")) {
            return str;
        }
        if (str.endsWith("s")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected String step1b(String str) {
        if (str.endsWith("eed")) {
            if (this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
                return str.substring(0, str.length() - 1);
            }
            return str;
        }
        if (str.endsWith("ed") && this.containsVowel(str.substring(0, str.length() - 2))) {
            return this.step1b2(str.substring(0, str.length() - 2));
        }
        if (str.endsWith("ing") && this.containsVowel(str.substring(0, str.length() - 3))) {
            return this.step1b2(str.substring(0, str.length() - 3));
        }
        return str;
    }

    protected String step1b2(String str) {
        if (str.endsWith("at") || str.endsWith("bl") || str.endsWith("iz")) {
            return String.valueOf(str) + "e";
        }
        if (str.length() > 1 && this.endsWithDoubleConsonent(str) && !str.endsWith("l") && !str.endsWith("s") && !str.endsWith("z")) {
            return str.substring(0, str.length() - 1);
        }
        if (this.stringMeasure(str) == 1 && this.endsWithCVC(str)) {
            return String.valueOf(str) + "e";
        }
        return str;
    }

    protected String step1c(String str) {
        if (str.endsWith("y") && this.containsVowel(str.substring(0, str.length() - 1))) {
            return String.valueOf(str.substring(0, str.length() - 1)) + "i";
        }
        return str;
    }

    protected String step2(String str) {
        if (str.endsWith("ational") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 5)) + "e";
        }
        if (str.endsWith("tional") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("enci") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("anci") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 1)) + "e";
        }
        if (str.endsWith("izer") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return str.substring(0, str.length() - 1);
        }
        if (str.endsWith("abli") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 1)) + "e";
        }
        if (str.endsWith("alli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("entli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("eli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ousli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ization") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 5)) + "e";
        }
        if (str.endsWith("ation") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 3)) + "e";
        }
        if (str.endsWith("ator") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 2)) + "e";
        }
        if (str.endsWith("alism") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iveness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("fulness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ousness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("aliti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iviti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 3)) + "e";
        }
        if (str.endsWith("biliti") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return String.valueOf(str.substring(0, str.length() - 5)) + "le";
        }
        return str;
    }

    protected String step3(String str) {
        if (str.endsWith("icate") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ative") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("alize") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iciti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ical") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ful") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    protected String step4(String str) {
        if (str.endsWith("al") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ance") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ence") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("er") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ic") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("able") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ible") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ant") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ement") && this.stringMeasure(str.substring(0, str.length() - 5)) > 1) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("ment") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ent") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if ((str.endsWith("sion") || str.endsWith("tion")) && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ou") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ism") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ate") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ous") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ive") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ize") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    protected String step5a(String str) {
        if (this.stringMeasure(str.substring(0, str.length() - 1)) > 1 && str.endsWith("e")) {
            return str.substring(0, str.length() - 1);
        }
        if (this.stringMeasure(str.substring(0, str.length() - 1)) == 1 && !this.endsWithCVC(str.substring(0, str.length() - 1)) && str.endsWith("e")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected String step5b(String str) {
        if (str.endsWith("l") && this.endsWithDoubleConsonent(str) && this.stringMeasure(str.substring(0, str.length() - 1)) > 1) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected boolean endsWithS(String str) {
        return str.endsWith("s");
    }

    protected boolean containsVowel(String str) {
        char[] strchars = str.toCharArray();
        int i = 0;
        while (i < strchars.length) {
            if (this.isVowel(strchars[i])) {
                return true;
            }
            ++i;
        }
        return str.indexOf(121) > -1;
    }

    public boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    protected boolean endsWithDoubleConsonent(String str) {
        char c = str.charAt(str.length() - 1);
        return c == str.charAt(str.length() - 2) && !this.containsVowel(str.substring(str.length() - 2));
    }

    protected int stringMeasure(String str) {
        int count = 0;
        boolean vowelSeen = false;
        char[] strchars = str.toCharArray();
        int i = 0;
        while (i < strchars.length) {
            if (this.isVowel(strchars[i])) {
                vowelSeen = true;
            } else if (vowelSeen) {
                ++count;
                vowelSeen = false;
            }
            ++i;
        }
        return count;
    }

    protected boolean endsWithCVC(String str) {
        char c2 = ' ';
        if (str.length() < 3) {
            return false;
        }
        char c = str.charAt(str.length() - 1);
        char v = str.charAt(str.length() - 2);
        c2 = str.charAt(str.length() - 3);
        if (c == 'w' || c == 'x' || c == 'y') {
            return false;
        }
        if (this.isVowel(c)) {
            return false;
        }
        if (!this.isVowel(v)) {
            return false;
        }
        return !this.isVowel(c2);
    }
}

