/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public final class NBTreeNoSplit
extends ClassifierSplitModel {
    private NaiveBayesUpdateable m_nb;
    private Discretize m_disc;
    private double m_errors;

    public NBTreeNoSplit() {
        this.m_numSubsets = 1;
    }

    public final void buildClassifier(Instances instances) throws Exception {
        this.m_nb = new NaiveBayesUpdateable();
        this.m_disc = new Discretize();
        this.m_disc.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.m_disc);
        this.m_nb.buildClassifier(instances2);
        if (instances2.numInstances() >= 5) {
            this.m_errors = NBTreeNoSplit.crossValidate(this.m_nb, instances2, new Random(1L));
        }
        this.m_numSubsets = 1;
    }

    public double getErrors() {
        return this.m_errors;
    }

    public Discretize getDiscretizer() {
        return this.m_disc;
    }

    public NaiveBayesUpdateable getNaiveBayesModel() {
        return this.m_nb;
    }

    public final int whichSubset(Instance instance) {
        return 0;
    }

    public final double[] weights(Instance instance) {
        return null;
    }

    public final String leftSide(Instances instances) {
        return "";
    }

    public final String rightSide(int n, Instances instances) {
        return "";
    }

    public final String sourceExpression(int n, Instances instances) {
        return "true";
    }

    public double classProb(int n, Instance instance, int n2) throws Exception {
        this.m_disc.input(instance);
        Instance instance2 = this.m_disc.output();
        return this.m_nb.distributionForInstance(instance2)[n];
    }

    public String toString() {
        return this.m_nb.toString();
    }

    public static double crossValidate(NaiveBayesUpdateable naiveBayesUpdateable, Instances instances, Random random) throws Exception {
        Classifier[] classifierArray = Classifier.makeCopies(naiveBayesUpdateable, 5);
        Evaluation evaluation = new Evaluation(instances);
        for (int i = 0; i < 5; ++i) {
            Instances instances2 = instances.testCV(5, i);
            for (int j = 0; j < instances2.numInstances(); ++j) {
                instances2.instance(j).setWeight(-instances2.instance(j).weight());
                ((NaiveBayesUpdateable)classifierArray[i]).updateClassifier(instances2.instance(j));
                instances2.instance(j).setWeight(-instances2.instance(j).weight());
            }
            evaluation.evaluateModel(classifierArray[i], instances2);
        }
        return evaluation.incorrect();
    }
}

