% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_SEQ2R.R
\name{read_SEQ2R}
\alias{read_SEQ2R}
\title{Parse a Risoe SEQ-file to a sequence neccessary for simulating quartz luminescence}
\usage{
read_SEQ2R(file, lab.dose_rate = 1, txtProgressBar = TRUE)
}
\arguments{
\item{file}{\code{\link{character}} (\bold{required}): a *.seq file created by the Risoe Sequence Editor}

\item{lab.dose_rate}{\code{\link{character}} (with default): set the dose rate of the radiation source
in the laboratory Gy/s. Default: 1 Gy/s}

\item{txtProgressBar}{\code{\link{logical}} (with default): enables or disables the txtProgressBar for a visuell
control of the progress. Default: txtProgressBar = TRUE}
}
\value{
This function returns a \code{\link{list}} with the parsed *.seq file and the required steps for
\code{\link{model_LuminescenceSignals}}.
}
\description{
A SEQ-file created by the Risoe Sequence Editor can be imported to simulate the sequence written
in the sequence editor.
}
\details{
\bold{Supported versions}: Supppored and tested: version 4.36.
}
\section{Function version}{
 0.1.0
}

\examples{
##search "example_SAR_cycle.SEQ" in "extdata" in package "RLumModel"
path <- system.file("extdata", "example_SAR_cycle.SEQ", package="RLumModel")

sequence <- read_SEQ2R(file = path, txtProgressBar = FALSE)

} 

\section{How to cite}{
Friedrich, J., 2019. read_SEQ2R(): Parse a Risoe SEQ-file to a sequence neccessary for simulating quartz luminescence. Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Schmidt, C., 2019. RLumModel: Solving Ordinary Differential Equations to Understand Luminescence. R package version 0.2.5. https://CRAN.R-project.org/package=RLumModel
}

\references{
Riso: Sequence Editor User Manual.
Available at: http://www.nutech.dtu.dk/english/-/media/Andre_Universitetsenheder/Nutech/Produkter
%20og%20services/Dosimetri/radiation_measurement_instruments/tl_osl_reader/Manuals/
SequenceEditor.ashx?la=da
}
\seealso{
\code{\link{model_LuminescenceSignals}}, \code{\link{readLines}}
}
\author{
Johannes Friedrich, University of Bayreuth (Germany),
}
