% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.Classification.R
\name{prediction.Classification}
\alias{prediction.Classification}
\title{Prediction from MKL model}
\usage{
prediction.Classification(model, ktest, train.outcome)
}
\arguments{
\item{model}{MKL model}

\item{ktest}{Gramm matrix of training data and test data}

\item{train.outcome}{Outcome for the training data}
}
\value{
yhat Predicted value for each test point

predicted Sign of yhat, which is the final predicted outcome
}
\description{
This function creates gramm matrix for traning set baed upon several types of kernel
and specified hyper paremeters. Matrix corresponds to similarity betwween 
each sample in the training set.
}
\examples{
library(kernlab)
library(caret)
data(benchmark.data)
example.data=benchmark.data[[1]]
training.samples=sample(1:dim(example.data)[1],floor(0.7*dim(example.data)[1]),replace=FALSE)
C=100
kernels=rep('radial',3)
degree=rep(0,3)
scale=rep(0,3)
sigma=c(0,2^seq(-3:0))
K=kernels.gen(example.data[,1:2], training.samples, kernels, degree, scale, sigma)
K.train=K$K.train
K.test=K$K.test
SEMKL.model=SEMKL.classification(K.train,example.data[training.samples,3], C)
predicted=prediction.Classification(SEMKL.model, K.test, example.data[training.samples,3])
confusionMatrix(factor(predicted$predict, levels=c(-1,1)),
                factor(example.data[-training.samples,3],levels=c(-1,1)))
}
