% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{trainMOA.MOA_regressor}
\alias{trainMOA.MOA_regressor}
\title{Train a MOA regressor (e.g. a FIMTDD) on a datastream}
\usage{
\method{trainMOA}{MOA_regressor}(model, formula, data, subset,
  na.action = na.exclude, transFUN = identity, chunksize = 1000,
  reset = TRUE, trace = FALSE, options = list(maxruntime = +Inf), ...)
}
\arguments{
\item{model}{an object of class \code{MOA_model}, as returned by \code{\link{MOA_regressor}}, e.g.
a \code{\link{FIMTDD}}}

\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an object of class \code{\link{datastream}} set up e.g. with \code{\link{datastream_file}}, 
\code{\link{datastream_dataframe}}, \code{\link{datastream_matrix}}, \code{\link{datastream_ffdf}} or your own datastream.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA}s. 
See \code{\link{model.frame}} for details. Defaults to \code{\link{na.exclude}}.}

\item{transFUN}{a function which is used after obtaining \code{chunksize} number of rows 
from the \code{data} datastream before applying \code{\link{model.frame}}. Useful if you want to 
change the results \code{get_points} on the datastream 
(e.g. for making sure the factor levels are the same in each chunk of processing, some data cleaning, ...). 
Defaults to \code{\link{identity}}.}

\item{chunksize}{the number of rows to obtain from the \code{data} datastream in one chunk of model processing.
Defaults to 1000. Can be used to speed up things according to the backbone architecture of
the datastream.}

\item{reset}{logical indicating to reset the \code{MOA_regressor} so that it forgets what it 
already has learned. Defaults to TRUE.}

\item{trace}{logical, indicating to show information on how many datastream chunks are already processed
as a \code{message}.}

\item{options}{a names list of further options. Currently not used.}

\item{...}{other arguments, currently not used yet}
}
\value{
An object of class MOA_trainedmodel which is a list with elements
\itemize{
\item{model: the updated supplied \code{model} object of class \code{MOA_regressor}}
\item{call: the matched call}
\item{na.action: the value of na.action}
\item{terms: the \code{terms} in the model}
\item{transFUN: the transFUN argument}
}
}
\description{
Train a MOA regressor (e.g. a FIMTDD) on a datastream
}
\examples{
mymodel <- MOA_regressor(model = "FIMTDD")
mymodel
data(iris)
iris <- factorise(iris)
irisdatastream <- datastream_dataframe(data=iris)
irisdatastream$get_points(3)
## Train the model
mytrainedmodel <- trainMOA(model = mymodel, 
 Sepal.Length ~ Petal.Length + Species, data = irisdatastream)
mytrainedmodel$model
irisdatastream$reset()
mytrainedmodel <- trainMOA(model = mytrainedmodel$model, 
 Sepal.Length ~ Petal.Length + Species, data = irisdatastream, 
 chunksize = 10, reset=FALSE, trace=TRUE)
mytrainedmodel$model 
}
\seealso{
\code{\link{MOA_regressor}}, \code{\link{datastream_file}}, \code{\link{datastream_dataframe}}, 
\code{\link{datastream_matrix}}, \code{\link{datastream_ffdf}}, \code{\link{datastream}},
\code{\link{predict.MOA_trainedmodel}}
}
