% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTL.R
\name{calcError}
\alias{calcError}
\title{Calculate the prediction error}
\usage{
calcError(m, newX = NULL, newY = NULL)
}
\arguments{
\item{m}{A MTL model}

\item{newX}{The feature matrices of new individuals}

\item{newY}{The responses of new individuals}
}
\value{
The averaged prediction error
}
\description{
Calculate the averaged prediction error across tasks. For
classification problem, the miss-classification rate is returned, and for
regression problem, the mean square error(MSE) is returned.
}
\examples{
#create example data
data<-Create_simulated_data(Regularization="L21", type="Regression")
#train a model 
model<-MTL(data$X, data$Y, type="Regression", Regularization="L21",
    Lam1=0.1, Lam2=0, opts=list(init=0,  tol=10^-6, maxIter=1500)) 
#calculate the training error
calcError(model, newX=data$X, newY=data$Y)
#calculate the test error
calcError(model, newX=data$tX, newY=data$tY)

}
