% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/escaping.R
\docType{methods}
\name{make.db.names,MySQLConnection,character-method}
\alias{SQLKeywords,MySQLConnection-method}
\alias{isSQLKeyword,MySQLConnection,character-method}
\alias{make.db.names,MySQLConnection,character-method}
\title{Make R/S-Plus identifiers into legal SQL identifiers}
\usage{
\S4method{make.db.names}{MySQLConnection,character}(dbObj, snames,
  keywords = .SQL92Keywords, unique = TRUE, allow.keywords = TRUE, ...)

\S4method{SQLKeywords}{MySQLConnection}(dbObj, ...)

\S4method{isSQLKeyword}{MySQLConnection,character}(dbObj, name,
  keywords = .MySQLKeywords, case = c("lower", "upper", "any")[3], ...)
}
\arguments{
\item{dbObj}{any MySQL object (e.g., \code{MySQLDriver}).}

\item{snames}{a character vector of R/S-Plus
identifiers (symbols) from which we need to make SQL identifiers.}

\item{keywords}{a character vector with SQL keywords, by default it is
\code{.MySQLKeywords} define in \code{RMySQL}. This may be overriden by
users.}

\item{unique}{logical describing whether the resulting set of SQL names
should be unique.  Its default is \code{TRUE}. Following the SQL 92
standard, uniqueness of SQL identifiers is determined regardless of whether
letters are upper or lower case.}

\item{allow.keywords}{logical describing whether SQL keywords should be
allowed in the resulting set of SQL names.  Its default is \code{TRUE}}

\item{...}{Unused, needed for compatibility with generic.}

\item{name}{a character vector of SQL identifiers we want to check against
keywords from the DBMS.}

\item{case}{a character string specifying whether to make the
comparison as lower case, upper case, or any of the two.  it defaults to
\code{any}.}
}
\description{
These methods are straight-forward implementations of the corresponding
generic functions.
}

