/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import de.hzi.infg.interfaces.TypeInterface;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.esearch.ESearchResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class RequestESearch
implements RequestInterface {
    private ESearchRequest request;
    private ESearchResult result;
    private HashMap<String, Object> resultMap;

    public RequestESearch(Map<String, String> arguments, EUtilsServiceStub service) throws ErrorFromWebserviceExeption, RemoteException {
        this.request = new ESearchRequest(arguments.keySet());
        this.resultMap = new HashMap();
        Utils.setParameterToRequest(this.request, arguments);
        this.result = service.run_eSearch(this.request);
        if (this.result.getERROR() != null) {
            throw new ErrorFromWebserviceExeption("The request produced an error: " + this.result.getERROR());
        }
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        this.createResultMap();
        Object firstObject = null;
        if (this.resultMap.containsKey(name) && (firstObject = this.resultMap.get(name.toLowerCase())) == null) {
            String[] tmpAr = new String[]{"empty"};
            return tmpAr;
        }
        if (firstObject == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (firstObject instanceof String) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not a complex type.");
        }
        ArrayList<String> listToReturn = new ArrayList<String>();
        Map<String, Object> firstMap = ((TypeInterface)firstObject).getParametersMap();
        ArrayList<String> orderedNames = new ArrayList<String>();
        String firstEntry = "";
        Iterator<String> firstKeyIter = firstMap.keySet().iterator();
        while (firstKeyIter.hasNext()) {
            String values = "";
            String firstKey = firstKeyIter.next();
            firstEntry = firstKeyIter.hasNext() ? String.valueOf(firstEntry) + firstKey + "{bw}" : String.valueOf(firstEntry) + firstKey;
            orderedNames.add(firstKey);
            Object secondObject = firstMap.get(firstKey);
            Stack<String> ss = new Stack<String>();
            ss.push(firstKey);
            values = Utils.recStructureBuild(values, secondObject, new Stack<String>(), ss, false, 0);
            listToReturn.add(values);
        }
        listToReturn.add(0, firstEntry);
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        this.createResultMap();
        Object stringToReturn = null;
        if (this.resultMap.containsKey(name) && (stringToReturn = this.resultMap.get(name)) == null) {
            stringToReturn = "empty";
        }
        if (stringToReturn == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (!(stringToReturn instanceof String)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is a complex type.");
        }
        return (String)stringToReturn;
    }

    @Override
    public String[] getParameter() {
        Class<?> resClazz = this.result.getClass();
        return Utils.getParameter(resClazz);
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        this.createResultMap();
        Object tmpObj = this.resultMap.get(parameter.toLowerCase());
        if (!this.resultMap.containsKey(parameter.toLowerCase())) {
            throw new ParameterNotFoundException("The parameter \"" + parameter + "\" has no further parameters to get.");
        }
        if (tmpObj instanceof String) {
            String[] tmp = new String[]{tmpObj.toString()};
            return tmp;
        }
        if (tmpObj == null) {
            String[] tmpReturn = new String[]{"empty"};
            return tmpReturn;
        }
        Map<String, Object> tmpParaMap = ((TypeInterface)tmpObj).getParametersMap();
        return tmpParaMap.keySet().toArray(new String[tmpParaMap.keySet().size()]);
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        if (this.result == null) {
            throw new NoResultSoFarException("There are no results to get.");
        }
        this.createResultMap();
        return this.resultMap;
    }

    private void createResultMap() {
        if (this.resultMap.size() != 0) {
            return;
        }
        String[] tmpParName = this.getParameter();
        int i = 0;
        while (i < tmpParName.length) {
            Method getMethod = Utils.getGetMethodByName(tmpParName[i], this.result.getClass());
            Object obj = null;
            try {
                obj = getMethod.invoke((Object)this.result, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.resultMap.put(tmpParName[i], obj);
            i += 2;
        }
    }

    public ESearchResult getResult() {
        return this.result;
    }
}

