/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg.efetch;

import de.hzi.infg.RInterface;
import de.hzi.infg.abstracts.EFetch;
import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EFetchJournalsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_journals.EFetchRequestDocument;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_journals.EFetchResultDocument;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.client.Options;
import org.xml.sax.SAXException;

public class EFetchJournals
extends EFetch {
    private EFetchRequestDocument request;
    private EFetchJournalsServiceStub journalsService;
    private Options options;

    public EFetchJournals() {
        GET_NAME = "xget";
        SET_NAME = "xset";
        this.request = EFetchRequestDocument.Factory.newInstance();
        this.request.addNewEFetchRequest();
        this.createOperationParameter(this.request.getEFetchRequest().getClass());
    }

    @Override
    public void fireRequest() throws RemoteException, ErrorFromWebserviceExeption {
        this.resultMap = new HashMap();
        this.journalsService = new EFetchJournalsServiceStub();
        this.options = this.journalsService._getServiceClient().getOptions();
        this.setOptions(this.options);
        Utils.setParameterToRequest(this.request.getEFetchRequest(), this.requestParameter);
        this.result = this.journalsService.run_eFetch(this.request);
        if (((EFetchResultDocument)this.result).getEFetchResult().getERROR() != null) {
            throw new ErrorFromWebserviceExeption("The request produced an error: " + ((EFetchResultDocument)this.result).getEFetchResult().getERROR());
        }
        this.createResultMap(((EFetchResultDocument)this.result).getEFetchResult());
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        Object firstObject = null;
        if (this.resultMap.containsKey(name) && (firstObject = this.resultMap.get(name.toLowerCase())) == null) {
            String[] tmpAr = new String[]{"empty"};
            return tmpAr;
        }
        if (firstObject == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (firstObject instanceof String) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not a complex type.");
        }
        ArrayList<String> listToReturn = new ArrayList<String>();
        String firstEntry = name;
        String values = "";
        Stack<String> ss = new Stack<String>();
        ss.push(name);
        values = Utils.recStructureBuildForXmlBeans(values, firstObject, new Stack<String>(), ss, false, 0);
        boolean xmlErrorOccured = false;
        if (RInterface.TIDY_XML) {
            String tidyValues = "";
            try {
                tidyValues = Utils.tidyXml(values);
            }
            catch (ParserConfigurationException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            catch (SAXException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            catch (IOException e) {
                xmlErrorOccured = true;
                e.printStackTrace();
            }
            listToReturn.add(tidyValues);
        } else if (xmlErrorOccured) {
            listToReturn.add(values);
        }
        listToReturn.add(0, firstEntry);
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    @Override
    public String[] getParameter() {
        Class<?> resClazz = ((EFetchResultDocument)this.result).getEFetchResult().getClass();
        return Utils.getParameter(resClazz);
    }
}

