% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileGpois.R
\name{QuantileGpois}
\alias{QuantileGpois}
\title{Computes Quantiles}
\usage{
QuantileGpois(p, theta, lambda, details = FALSE)
}
\arguments{
\item{p}{percentile of the generalized Poisson distribution, p should be between 0 and 1.}

\item{theta}{the rate parameter in the generalized Poisson distribution. It has to be a positive number.}

\item{lambda}{the dispersion parameter in the generalized Poisson distribution.
It has to be less than 1. For lambda < 0, lambda must be greater than or equal to -theta/4.}

\item{details}{index of whether to display the probabilities and cumulative probabilities.
Default is set to FALSE.}
}
\value{
quantile of the specified distribution if the parameter \emph{details} is set to FALSE, 
detailed information of probabilities and cumulative probabilities otherwise.
}
\description{
\code{QuantileGpois} computes the quantile for the generalized Poisson distribution
 for specified values of percentile, rate and dispersion parameters.
}
\examples{
 QuantileGpois(0.98, 1, -0.2, details = TRUE)
 QuantileGpois(0.80, 2, 0.025, details = FALSE)
}
\references{
Demirtas, H. (2017). On accurate and precise generation of generalized
 Poisson variates. \emph{Communications in Statistics - Simulation and Computation},
  \bold{46(1)}, 489-499.
}
