% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertClass.R
\name{convertclass}
\alias{convertclass}
\title{Converts Binary Vector into 1 and 0}
\usage{
convertclass(x, reference = NULL)
}
\arguments{
\item{x}{A vector of exactly two unique values.}

\item{reference}{The reference value. Depending on the class of \code{x},
it can be numeric or character type. If specified, this value
is converted to 0 and other is converted to 1. If NULL, reference is
set alphabetically.}
}
\value{
A numeric vector of 1 and 0.
}
\description{
\code{convertclass} converts a binary variable with any
response into 1/0 response. It is used internally in other functions of
package \pkg{ROCit}.
}
\section{Comment}{

\code{convertclass} is used internally in other function(s) of \pkg{ROCit}.
}

\examples{
x <- c("cat", "cat", "dog", "cat")
convertclass(x) # by default, "cat" is converted to 0
convertclass(x, reference = "dog")

# ----------------------------

set.seed(10)
x <- round(runif(10, 2, 3))
convertclass(x, reference = 3)
# numeric reference can be supplied as character
convertclass(x, reference = "3") # same result


}
