% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.rv_histogram.R
\name{rv_histogram}
\alias{rv_histogram}
\title{rv_histogram}
\description{
rv_histogram distribution in OOP way.
}
\details{
Use quantile to fit the histogram
}
\examples{
## Generate sample
X = numeric(10000)
X[1:5000] = stats::rnorm( n = 5000 , mean = 2 , sd = 1 )
X[5000:10000] = stats::rexp( n = 5000 , rate = 1 )

## And fit it
rvX = rv_histogram$new()
rvX$fit(X)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{min}}{[double] min value for the estimation}

\item{\code{max}}{[double] max value for the estimation}

\item{\code{tol}}{[double] numerical tolerance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rv_histogram-new}{\code{rv_histogram$new()}}
\item \href{#method-rv_histogram-rvs}{\code{rv_histogram$rvs()}}
\item \href{#method-rv_histogram-density}{\code{rv_histogram$density()}}
\item \href{#method-rv_histogram-logdensity}{\code{rv_histogram$logdensity()}}
\item \href{#method-rv_histogram-cdf}{\code{rv_histogram$cdf()}}
\item \href{#method-rv_histogram-icdf}{\code{rv_histogram$icdf()}}
\item \href{#method-rv_histogram-sf}{\code{rv_histogram$sf()}}
\item \href{#method-rv_histogram-isf}{\code{rv_histogram$isf()}}
\item \href{#method-rv_histogram-fit}{\code{rv_histogram$fit()}}
\item \href{#method-rv_histogram-clone}{\code{rv_histogram$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-new"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-new}{}}}
\subsection{Method \code{new()}}{
Create a new rv_histogram object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{If a param `Y` is given, the fit method is called with `...`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `rv_histogram` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-density"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-density}{}}}
\subsection{Method \code{density()}}{
Density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$density(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-logdensity}{}}}
\subsection{Method \code{logdensity()}}{
Log density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$logdensity(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the log-density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the log density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-sf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-isf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-fit"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method for the histograms
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$fit(Y, bins = as.integer(1000))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the histogram}

\item{\code{bins}}{[vector or integer] bins values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`self`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_histogram-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rv_histogram-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_histogram$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
