% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.lm.rrpp.r
\name{anova.lm.rrpp}
\alias{anova.lm.rrpp}
\title{ANOVA for lm.rrpp model fits}
\usage{
\method{anova}{lm.rrpp}(object, ..., effect.type = c("F", "cohenf", "SS",
  "MS", "Rsq"), error = NULL)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}}

\item{...}{Other arguments passed to ANOVA}

\item{effect.type}{One of "F", "cohenf", "SS", "MS", "Rsq" to choose from which distribution
of statistics to calculate effect sizes (Z).  See \code{\link{lm.rrpp}}.}

\item{error}{An optional character string to define MS error term for calculation of F values.
See \code{\link{lm.rrpp}} for examples.}
}
\description{
Computes an analysis of variance table using distributions of random
statistics from \code{\link{lm.rrpp}}.
}
\examples{
# See examples for lm.rrpp to see how anova.lm.rrpp works in conjunction
# with other functions

data(Pupfish)
names(Pupfish)
Pupfish$logSize <- log(Pupfish$CS) # better to not have functions in formulas

fit <- lm.rrpp(coords ~ logSize + Sex*Pop, SS.type = "I", data = Pupfish) 
anova(fit)
anova(fit, effect.type = "MS")
anova(fit, effect.type = "Rsq")
anova(fit, effect.type = "cohenf")

# see lm.rrpp examples for mixed model ANOVA example and how to vary SS type

}
\author{
Michael Collyer
}
\keyword{utilities}
