% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRPP.utils.r
\name{plot.lm.rrpp}
\alias{plot.lm.rrpp}
\title{Plot Function for RRPP}
\usage{
\method{plot}{lm.rrpp}(
  x,
  type = c("diagnostics", "regression", "PC"),
  predictor = NULL,
  reg.type = c("PredLine", "RegScore"),
  ...
)
}
\arguments{
\item{x}{plot object (from \code{\link{lm.rrpp}})}

\item{type}{Indicates which type of plot, choosing among diagnostics,
regression, or principal component plots.  Diagnostic plots are similar to 
\code{\link{lm}} diagnostic plots, but for multivariate data.  Regression plots
plot multivariate dispersion in some fashion against predictor values. PC plots
project data onto the eigenvectors of the covariance matrix for fitted values.}

\item{predictor}{An optional vector if "regression" plot type is chosen, 
and is a variable likely used in \code{\link{lm.rrpp}}.
This vector is a vector of covariate values equal to the number of observations.}

\item{reg.type}{If "regression" is chosen for plot type, this argument
indicates whether prediction line 
(PredLine) or regression score (RegScore) plotting is performed.  
For explanation of prediction line,
see Adams and Nistri (2010).  For explanation of regression score, see 
Drake and Klingenberg (2008).}

\item{...}{other arguments passed to plot (helpful to employ
different colors or symbols for different groups).  See
\code{\link{plot.default}} and \code{\link{par}}}
}
\description{
Plot Function for RRPP
}
\references{
Drake, A. G., and C. P. Klingenberg. 2008. 
The pace of morphological change: Historical 
transformation of skull shape in St Bernard dogs. Proc. R. Soc. B. 275:71-76.

Adams, D. C., and A. Nistri. 2010. Ontogenetic convergence 
and evolution of foot morphology 
in European cave salamanders (Family: Plethodontidae). BMC Evol. Biol. 10:1-10.
}
\author{
Michael Collyer
}
\keyword{utilities}
\keyword{visualization}
