% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.add.grid.values.to.points}
\alias{rsaga.add.grid.values.to.points}
\title{Add Grid Values to Point Shapefile}
\usage{
rsaga.add.grid.values.to.points(in.shapefile, in.grids, out.shapefile,
  method = c("nearest.neighbour", "bilinear", "idw", "bicubic.spline",
  "b.spline"), ...)
}
\arguments{
\item{in.shapefile}{Input point shapefile (default extension: \code{.shp}).}

\item{in.grids}{Input: character vector with names of (one or more) SAGA GIS grid files to be converted into a point shapefile.}

\item{out.shapefile}{Output point shapefile (default extension: \code{.shp}).}

\item{method}{interpolation method to be used; choices: nearest neighbour interpolation (default), bilinear interpolation, inverse distance weighting, bicubic spline interpolation, B-splines.}

\item{...}{Optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}, including the \code{env} RSAGA geoprocessing environment.}
}
\description{
Pick values from SAGA grids and attach them as a new variables to a point shapefile.
}
\details{
Retrieves information from the selected grids at the positions of the points of the selected points layer and adds it to the resulting layer.
}
\note{
This function uses module \code{Add Grid Values to Points} in SAGA GIS library \code{shapes_grid}.
}
\seealso{
\code{\link[=pick.from.points]{pick.from.points()}}, \code{\link[=pick.from.ascii.grid]{pick.from.ascii.grid()}}, \code{\link[=pick.from.saga.grid]{pick.from.saga.grid()}}, \code{\link[=rsaga.grid.to.points]{rsaga.grid.to.points()}}
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA modules)
}
\keyword{interface}
\keyword{spatial}
