% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.symbolic_df.R
\name{plot.symbolic_tbl}
\alias{plot.symbolic_tbl}
\title{Function for plotting a symbolic object}
\usage{
\method{plot}{symbolic_tbl}(x, col = NA, matrix.form = NA,
  border = FALSE, size = 1, title = TRUE, show.type = FALSE,
  font.size = 1, reduce = FALSE, hist.angle.x = 60, ...)
}
\arguments{
\item{x}{The symbolic object.}

\item{col}{A specification for the default plotting color.}

\item{matrix.form}{A vector of the form c(num.rows,num.columns).}

\item{border}{A logical value indicating whether border should be plotted.}

\item{size}{The magnification to be used for each graphic.}

\item{title}{A logical value indicating whether title should be plotted.}

\item{show.type}{A logical value indicating whether type should be plotted.}

\item{font.size}{The font size of graphics.}

\item{reduce}{A logical value indicating whether values different from zero should be plotted in modal and set graphics.}

\item{hist.angle.x}{The angle of labels in y axis. Only for histogram plot}

\item{...}{Arguments to be passed to methods.}
}
\value{
A plot of the symbolic data table.
}
\description{
Function for plotting a symbolic object
}
\examples{
\dontrun{
data(oils)
plot(oils)
plot(oils, border = T, size = 1.3)
}
}
\author{
Andres Navarro
}
\keyword{Plot}
\keyword{Symbolic}
\keyword{data}
\keyword{table}
