% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\docType{methods}
\name{sqlite-transaction}
\alias{sqlite-transaction}
\alias{dbBegin,SQLiteConnection-method}
\alias{dbCommit,SQLiteConnection-method}
\alias{dbRollback,SQLiteConnection-method}
\title{SQLite transaction management}
\usage{
\S4method{dbBegin}{SQLiteConnection}(conn, .name = NULL, ...,
  name = NULL)

\S4method{dbCommit}{SQLiteConnection}(conn, .name = NULL, ...,
  name = NULL)

\S4method{dbRollback}{SQLiteConnection}(conn, .name = NULL, ...,
  name = NULL)
}
\arguments{
\item{conn}{a \code{\linkS4class{SQLiteConnection}} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{.name}{For backward compatibility, do not use.}

\item{...}{Needed for compatibility with generic. Otherwise ignored.}

\item{name}{Supply a name to use a named savepoint. This allows you to
nest multiple transaction}
}
\description{
By default, SQLite is in auto-commit mode. \code{dbBegin()} starts
a SQLite transaction and turns auto-commit off. \code{dbCommit()} and
\code{dbRollback()} commit and rollback the transaction, respectively and turn
auto-commit on.
\code{\link[DBI:dbWithTransaction]{DBI::dbWithTransaction()}} is a convenient wrapper that makes sure that
\code{dbCommit()} or \code{dbRollback()} is called.
}
\examples{
library(DBI)
con <- dbConnect(SQLite(), ":memory:")
dbWriteTable(con, "arrests", datasets::USArrests)
dbGetQuery(con, "select count(*) from arrests")

dbBegin(con)
rs <- dbSendStatement(con, "DELETE from arrests WHERE Murder > 1")
dbGetRowsAffected(rs)
dbClearResult(rs)

dbGetQuery(con, "select count(*) from arrests")

dbRollback(con)
dbGetQuery(con, "select count(*) from arrests")[1, ]

dbBegin(con)
rs <- dbSendStatement(con, "DELETE FROM arrests WHERE Murder > 5")
dbClearResult(rs)
dbCommit(con)
dbGetQuery(con, "SELECT count(*) FROM arrests")[1, ]

# Named savepoints can be nested --------------------------------------------
dbBegin(con, name = "a")
dbBegin(con, name = "b")
dbRollback(con, name = "b")
dbCommit(con, name = "a")

dbDisconnect(con)
}
\seealso{
The corresponding generic functions \code{\link[DBI:dbBegin]{DBI::dbBegin()}}, \code{\link[DBI:dbCommit]{DBI::dbCommit()}},
and \code{\link[DBI:dbRollback]{DBI::dbRollback()}}.
}
