% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluate.R
\name{split_random}
\alias{split_random}
\title{Randomly split dataset in multiple parts}
\usage{
split_random(df, formula = NULL, splits = c(0.5, 0.5), min_class = 0)
}
\arguments{
\item{df}{data.frame; Data frame of interest}

\item{formula}{formula; Formula to indicate the outputs}

\item{splits}{numeric; Probability of of assigning to each part, automatically normalized, should be >1}

\item{min_class}{integer; minimum number of objects per class in each part}
}
\value{
list of data.frames
}
\description{
The data.frame should start with a vector containing labels, or formula should be defined.
}
\examples{
library(dplyr)

df <- generate2ClassGaussian(200,d=2)
dfs <- df \%>\% split_random(Class~.,split=c(0.5,0.3,0.2),min_class=1) 
names(dfs) <- c("Train","Validation","Test")
lapply(dfs,summary)

}
\seealso{
Other RSSL utilities: \code{\link{LearningCurveSSL}},
  \code{\link{SSLDataFrameToMatrices}},
  \code{\link{add_missinglabels_mar}},
  \code{\link{df_to_matrices}},
  \code{\link{measure_accuracy}},
  \code{\link{missing_labels}},
  \code{\link{split_dataset_ssl}},
  \code{\link{true_labels}}
}

