% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{stripe_create_card_token}
\alias{stripe_create_card_token}
\title{Create a Card Token}
\usage{
stripe_create_card_token(api_key, args)
}
\arguments{
\item{api_key}{Your Stripe API Key}

\item{args}{A list which must contain card information including
\describe{
   \item{number}{\strong{required}}
   \item{cvc}{\strong{required}}
   \item{exp_month}{\strong{required}}
   \item{exp_year}{\strong{required}}
   \item{address_city}{\emph{optional}}
   \item{address_country}{\emph{optional}}
   \item{address_line1}{\emph{optional}}
   \item{address_line2}{\emph{optional}}
   \item{address_state}{\emph{optional}}
   \item{address_zip}{\emph{optional}}
   \item{name}{\emph{optional}}
   \item{customer}{\emph{optional} Customer to attach token to.}
}}
}
\value{
A data frame with the new card token info if successful.
}
\description{
Create a card token to be used by other functions.  You can use this to create a charge,
or to attach to a customer.
}
\examples{
\dontrun{stripe_create_card_token("sk_test_BQokikJOvBiI2HlWgH4olfQ2",
list(card=list(number="4242424242424242", exp_month="03", exp_year="2018")))}

}

