% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_api_prj_config.R
\name{prj_config_set_rversion}
\alias{prj_config_set_rversion}
\title{Updates project configuration to use specified R Version.}
\usage{
prj_config_set_rversion(rver, prj = NULL, validate = TRUE)
}
\arguments{
\item{rver}{R version to be used by the project. (type: character)}

\item{prj}{project object to update configuration for. If not passed the loaded
project will used or the default whichever exists. Will init default project
from the working directory if no default project exists.
(type: rsuite_project, default: NULL)}

\item{validate}{If TRUE will check if R version is valid for the platform.
(type: logical, default: TRUE)}
}
\description{
Project configuration (together with R version to be used) is stored in
PARAMETERS file in the project folder.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# present initial project configuration
cat(readLines(file.path(prj$path, "PARAMETERS")), sep = "\\n")

# set repositories to use
prj_config_set_rversion("3.2", prj = prj, validate = FALSE)

# present final project configuration
cat(readLines(file.path(prj$path, "PARAMETERS")), sep = "\\n")

}
\seealso{
Other in project configuration: \code{\link{prj_config_set_repo_adapters}}
}
\concept{in project configuration}
