% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.var.se}
\alias{sep.var.se}
\title{Population sensitivity for varying unit sensitivity}
\usage{
sep.var.se(N = NA, se, pstar)
}
\arguments{
\item{N}{population size (number of units or clusters), N must be >= length(se))
or NA if unknown}

\item{se}{vector of unit sensitivity values (proportion) for each unit sampled}

\item{pstar}{specified design prevalence (scalar)}
}
\value{
a scalar of population-level sensitivity
}
\description{
Calculates population-level sensitivity where unit sensitivity
  varies and using the appropriate method, depending on whether or not N provided
  (hypergeometric if N provided, binomial otherwise), assuming perfect
  test specificity and representative sampling
}
\examples{
# examples of sep.var.se - checked
sens<- c(rep(0.9, 50), rep(0.95, 100))
sep.var.se(NA, sens, 0.01)
sep.var.se(se=sens, pstar=0.01)
sep.var.se(N=500, sens, 0.01)
sep.var.se(NA, runif(150, 0.95, 0.99), 0.02)
sep.var.se(500, runif(150, 0.95, 0.99), 0.02)
}
\keyword{methods}

