% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPIT.R
\name{getPIT}
\alias{getPIT}
\title{Estimation of credit transition probabilities}
\usage{
getPIT(data, startDate, endDate, method, snapshots, interval)
}
\arguments{
\item{data}{a table containing historical credit ratings data (i.e., credit migration data). A dataframe of size \emph{nRecords} x 3 where each row contains an ID (column 1), a date (column 2), and a credit rating (column 3); The credit rating is the rating assigned to the corresponding ID on the corresponding date.}

\item{startDate}{start date of the estimation time window, in string or numeric format. The default start date is the earliest date in 'data'.}

\item{endDate}{end date of the estimation time window, in string or numeric format. The default end date is the latest date in 'data'. The end date cannot be a date before the start date.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}
}
\value{
Returns the following objects:

\item{\strong{sampleTotals}}{a list containing the following count components:}

\item{\emph{totalsVec}}{A vector of size \emph{1-by-nRatings.} For 'duration' calculations, the vector stores the total time spent on \emph{rating i.} For 'cohort' calculations, the vector stores the initial counts (start vector) in \emph{rating i.}}

\item{\emph{totalsMat}}{A matrix of size \emph{nRatings-by-nRatings.} For 'duration' calculations, the matrix contains the total transitions observed out of \emph{rating i} into \emph{rating j} (all the diagonal elements are zero). For 'cohort' calculations, the matrix contains the total transitions observed from \emph{rating i} to \emph{rating j.}}

\item{\emph{algorithm}}{A character vector with values 'duration' or 'cohort'.}

\item{\strong{transMat}}{Matrix of transition probabilities in percent. The size of the transition matrix is \emph{nRatings-by-nRatings.}}

\item{\strong{genMat}}{Generator Matrix. \emph{use only with duration method}}
}
\description{
This function is used to estimate Point-in-Time transition probabilities and counts given historical credit data (a.k.a., credit migration data).
}
\examples{
\dontrun{
snapshots <- 4     #This uses quarterly snapshots
interval <- .25     #This gives quarterly transition matrix
startDate  <- "2000-01-01"
endDate    <- "2005-01-01"
Example<-getPIT(data,startDate, endDate,'cohort', snapshots, interval)
}
}
\author{
Abdoulaye (Ab) N'Diaye
}
