% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{calc.cfb}
\alias{calc.cfb}
\title{Calculate CFB}
\usage{
calc.cfb(data, annot, baseline.flag, baseline.val)
}
\arguments{
\item{data}{Dataframe with subject id, annotation flag, gene id and cpm value
(from count tables) columns.}

\item{annot}{A long-format dataframe with any pertinent treatment data about
the samples. The only required column is one titled the \code{sample.id}
value with values matching the column names of sample IDs in \code{data}.
Additional columns can contain information such as treament
compounds, dates of sample collection, or dosage quantities.}

\item{baseline.flag}{A character vector of column names. These columns in \code{annot}
contain the values to compare across.}

\item{baseline.val}{A character vector of values. This vector must be the
same length as \code{baseline.flag}, and the value at each index must
represent a value from the column given by the corresponding index
in \code{baseline.flag}.}
}
\description{
This function calculates the change from baseline.
}
