\name{cook.dist}
\alias{cook.dist}
\title{
Graphe des distances de Cook individuelles dans une regression lineaire simple au sens des moindres carres
}
\description{
Version plus intuitive du graphe trac par dfaut par R.
}
\usage{
cook.dist(model, avert = 0.6)
}
\arguments{
  \item{model}{
modle de la rgression, de la forme \code{lm(y~x)}.
}
  \item{avert}{
seuil  partir duquel un avertissement graphique apparat, en proportion du seuil thorique.
}
}
\details{
Lorsque que la distance de Cook d'un individu est proche du seuil thorique, une grande attention doit tre port  cet individu.  Il est conseill d'analyser son influence en comparant le modle  un second dans lequel l'individu en question a t retir.
}
\author{
Maxime Herv, d'aprs Gal Millot
}
\seealso{
\code{\link{lm}}, \code{\link{ls.diag}}, \code{\link{lsfit}}
}
\examples{
# Graphe par defaut
x<-1:50
y<-1:50+rnorm(50,0,4)
regression<-lm(y~x)
cook.dist(regression)

# Avertissement quand la distance vaut 80 pc de la distance theorique
cook.dist(regression,avert=0.8)
}
