% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetOperations.R, R/package-RVenn.R
\docType{methods}
\name{overlap,Venn-method}
\alias{overlap,Venn-method}
\alias{overlap}
\title{Intersection of many sets}
\usage{
\S4method{overlap}{Venn}(venn, slice = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) A character or numeric vector to pick sets. Default
is "all", meaning the intersection will be calculated for all the sets.}
}
\value{
A character or numeric vector showing the union of the sets.
}
\description{
\code{overlap} returns the same elements of the sets in a \code{Venn} object.
}
\examples{
venn = construct(list(letters[1:10], letters[3:12], letters[6:15]))
overlap(venn)
overlap(venn, slice = c(1, 2))
}
