/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CostSensitiveClassifier
extends RandomizableSingleClassifierEnhancer
implements OptionHandler,
Drawable {
    static final long serialVersionUID = -720658209263002404L;
    public static final int MATRIX_ON_DEMAND = 1;
    public static final int MATRIX_SUPPLIED = 2;
    public static final Tag[] TAGS_MATRIX_SOURCE = new Tag[]{new Tag(1, "Load cost matrix on demand"), new Tag(2, "Use explicit cost matrix")};
    protected int m_MatrixSource = 1;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    protected String m_CostFile;
    protected CostMatrix m_CostMatrix = new CostMatrix(1);
    protected boolean m_MinimizeExpectedCost;

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    public CostSensitiveClassifier() {
        this.m_Classifier = new ZeroR();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tMinimize expected misclassification cost. Default is to\n\treweight training instances according to costs per class", "M", 0, "-M"));
        vector.addElement(new Option("\tFile name of a cost matrix to use. If this is not supplied,\n\ta cost matrix will be loaded on demand. The name of the\n\ton-demand file is the relation name of the training data\n\tplus \".cost\", and the path to the on-demand file is\n\tspecified with the -N option.", "C", 1, "-C <cost file name>"));
        vector.addElement(new Option("\tName of a directory to search for cost files when loading\n\tcosts on demand (default current directory).", "N", 1, "-N <directory>"));
        vector.addElement(new Option("\tThe cost matrix in Matlab single line format.", "cost-matrix", 1, "-cost-matrix <matrix>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.setMinimizeExpectedCost(Utils.getFlag('M', stringArray));
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            try {
                this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(string2))));
            }
            catch (Exception exception) {
                this.setCostMatrix(null);
            }
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
            this.m_CostFile = string2;
        } else {
            this.setCostMatrixSource(new SelectedTag(1, TAGS_MATRIX_SOURCE));
        }
        String string3 = Utils.getOption('D', stringArray);
        if (string3.length() != 0) {
            this.setOnDemandDirectory(new File(string3));
        }
        if ((string = Utils.getOption("cost-matrix", stringArray)).length() != 0) {
            StringWriter stringWriter = new StringWriter();
            CostMatrix.parseMatlab(string).write(stringWriter);
            this.setCostMatrix(new CostMatrix(new StringReader(stringWriter.toString())));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 7];
        int n = 0;
        if (this.m_MatrixSource == 2) {
            if (this.m_CostFile != null) {
                stringArray2[n++] = "-C";
                stringArray2[n++] = "" + this.m_CostFile;
            } else {
                stringArray2[n++] = "-cost-matrix";
                stringArray2[n++] = this.getCostMatrix().toMatlab();
            }
        } else {
            stringArray2[n++] = "-N";
            stringArray2[n++] = "" + this.getOnDemandDirectory();
        }
        if (this.getMinimizeExpectedCost()) {
            stringArray2[n++] = "-M";
        }
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        while (n < stringArray2.length) {
            if (stringArray2[n] == null) {
                stringArray2[n] = "";
            }
            ++n;
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "A metaclassifier that makes its base classifier cost-sensitive. Two methods can be used to introduce cost-sensitivity: reweighting training instances according to the total cost assigned to each class; or predicting the class with minimum expected misclassification cost (rather than the most likely class). Performance can often be improved by using a Bagged classifier to improve the probability estimates of the base classifier.";
    }

    public String costMatrixSourceTipText() {
        return "Sets where to get the cost matrix. The two options areto use the supplied explicit cost matrix (the setting of the costMatrix property), or to load a cost matrix from a file when required (this file will be loaded from the directory set by the onDemandDirectory property and will be named relation_name" + CostMatrix.FILE_EXTENSION + ").";
    }

    public SelectedTag getCostMatrixSource() {
        return new SelectedTag(this.m_MatrixSource, TAGS_MATRIX_SOURCE);
    }

    public void setCostMatrixSource(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MATRIX_SOURCE) {
            this.m_MatrixSource = selectedTag.getSelectedTag().getID();
        }
    }

    public String onDemandDirectoryTipText() {
        return "Sets the directory where cost files are loaded from. This option is used when the costMatrixSource is set to \"On Demand\".";
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File file) {
        this.m_OnDemandDirectory = file.isDirectory() ? file : new File(file.getParent());
        this.m_MatrixSource = 1;
    }

    public String minimizeExpectedCostTipText() {
        return "Sets whether the minimum expected cost criteria will be used. If this is false, the training data will be reweighted according to the costs assigned to each class. If true, the minimum expected cost criteria will be used.";
    }

    public boolean getMinimizeExpectedCost() {
        return this.m_MinimizeExpectedCost;
    }

    public void setMinimizeExpectedCost(boolean bl) {
        this.m_MinimizeExpectedCost = bl;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        if (classifier instanceof OptionHandler) {
            return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
        }
        return classifier.getClass().getName();
    }

    public String costMatrixTipText() {
        return "Sets the cost matrix explicitly. This matrix is used if the costMatrixSource property is set to \"Supplied\".";
    }

    public CostMatrix getCostMatrix() {
        return this.m_CostMatrix;
    }

    public void setCostMatrix(CostMatrix costMatrix) {
        this.m_CostMatrix = costMatrix;
        this.m_MatrixSource = 2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        if (this.m_MatrixSource == 1) {
            object = instances.relationName() + CostMatrix.FILE_EXTENSION;
            File file = new File(this.getOnDemandDirectory(), (String)object);
            if (!file.exists()) {
                throw new Exception("On-demand cost file doesn't exist: " + file);
            }
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(file))));
        } else if (this.m_CostMatrix == null) {
            this.m_CostMatrix = new CostMatrix(instances.numClasses());
            this.m_CostMatrix.readOldFormat(new BufferedReader(new FileReader(this.m_CostFile)));
        }
        if (!this.m_MinimizeExpectedCost) {
            object = null;
            if (!(this.m_Classifier instanceof WeightedInstancesHandler)) {
                object = new Random(this.m_Seed);
            }
            instances = this.m_CostMatrix.applyCostMatrix(instances, (Random)object);
        }
        this.m_Classifier.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_MinimizeExpectedCost) {
            return this.m_Classifier.distributionForInstance(instance);
        }
        double[] dArray = this.m_Classifier.distributionForInstance(instance);
        double[] dArray2 = this.m_CostMatrix.expectedCosts(dArray, instance);
        int n = Utils.minIndex(dArray2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i == n ? 1.0 : 0.0;
        }
        return dArray;
    }

    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public String toString() {
        if (this.m_Classifier == null) {
            return "CostSensitiveClassifier: No model built yet.";
        }
        String string = "CostSensitiveClassifier using ";
        string = this.m_MinimizeExpectedCost ? string + "minimized expected misclasification cost\n" : string + "reweighted training instances\n";
        string = string + "\n" + this.getClassifierSpec() + "\n\nClassifier Model\n" + this.m_Classifier.toString() + "\n\nCost Matrix\n" + this.m_CostMatrix.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        CostSensitiveClassifier.runClassifier(new CostSensitiveClassifier(), stringArray);
    }
}

