/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Memory;
import weka.core.Version;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.SimpleCLI;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;

public class GUIChooser
extends JFrame {
    protected Button m_SimpleBut = new Button("Simple CLI");
    protected Button m_ExplorerBut = new Button("Explorer");
    protected Button m_ExperimenterBut = new Button("Experimenter");
    protected Button m_KnowledgeFlowBut = new Button("KnowledgeFlow");
    protected Button m_ArffViewerBut = new Button("ArffViewer");
    protected Vector m_ArffViewers = new Vector();
    protected Button m_LogWindowBut = new Button("Log");
    protected SimpleCLI m_SimpleCLI;
    protected JFrame m_ExplorerFrame;
    protected JFrame m_ExperimenterFrame;
    protected JFrame m_KnowledgeFlowFrame;
    protected static LogWindow m_LogWindow = new LogWindow();
    Image m_weka = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif"));
    private static GUIChooser m_chooser;
    private static Memory m_Memory;

    public GUIChooser() {
        super("Weka GUI Chooser");
        Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
        this.setIconImage(image);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("GUI"));
        jPanel.setLayout(new GridLayout(3, 2));
        jPanel.add(this.m_SimpleBut);
        jPanel.add(this.m_ExplorerBut);
        jPanel.add(this.m_ExperimenterBut);
        jPanel.add(this.m_KnowledgeFlowBut);
        jPanel.add(this.m_ArffViewerBut);
        jPanel.add(this.m_LogWindowBut);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setToolTipText("Weka, a native bird of New Zealand");
        ImageIcon imageIcon = new ImageIcon(this.m_weka);
        JLabel jLabel = new JLabel(imageIcon);
        jPanel2.add(jLabel);
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(8, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.add(new JLabel("Waikato Environment for", 0));
        jPanel3.add(new JLabel("Knowledge Analysis", 0));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel("Version " + Version.VERSION, 0));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel("(c) 1999 - 2007", 0));
        jPanel3.add(new JLabel("University of Waikato", 0));
        jPanel3.add(new JLabel("New Zealand", 0));
        this.getContentPane().add((Component)jPanel3, "North");
        this.m_SimpleBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SimpleCLI == null) {
                    GUIChooser.this.m_SimpleBut.setEnabled(false);
                    try {
                        GUIChooser.this.m_SimpleCLI = new SimpleCLI();
                    }
                    catch (Exception exception) {
                        throw new Error("Couldn't start SimpleCLI!");
                    }
                    GUIChooser.this.m_SimpleCLI.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_SimpleCLI.dispose();
                            GUIChooser.this.m_SimpleCLI = null;
                            GUIChooser.this.m_SimpleBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SimpleCLI.setVisible(true);
                }
            }
        });
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExplorerFrame == null) {
                    GUIChooser.this.m_ExplorerBut.setEnabled(false);
                    GUIChooser.this.m_ExplorerFrame = new JFrame("Weka Explorer");
                    GUIChooser.this.m_ExplorerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExplorerFrame.getContentPane().add((Component)new Explorer(), "Center");
                    GUIChooser.this.m_ExplorerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExplorerFrame.dispose();
                            GUIChooser.this.m_ExplorerFrame = null;
                            GUIChooser.this.m_ExplorerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExplorerFrame.pack();
                    GUIChooser.this.m_ExplorerFrame.setSize(800, 600);
                    GUIChooser.this.m_ExplorerFrame.setVisible(true);
                }
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExperimenterFrame == null) {
                    GUIChooser.this.m_ExperimenterBut.setEnabled(false);
                    GUIChooser.this.m_ExperimenterFrame = new JFrame("Weka Experiment Environment");
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                    GUIChooser.this.m_ExperimenterFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExperimenterFrame.dispose();
                            GUIChooser.this.m_ExperimenterFrame = null;
                            GUIChooser.this.m_ExperimenterBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExperimenterFrame.pack();
                    GUIChooser.this.m_ExperimenterFrame.setSize(800, 600);
                    GUIChooser.this.m_ExperimenterFrame.setVisible(true);
                }
            }
        });
        KnowledgeFlowApp.addStartupListener(new StartUpListener(){

            public void startUpComplete() {
                if (GUIChooser.this.m_KnowledgeFlowFrame == null) {
                    final KnowledgeFlowApp knowledgeFlowApp = KnowledgeFlowApp.getSingleton();
                    GUIChooser.this.m_KnowledgeFlowBut.setEnabled(false);
                    GUIChooser.this.m_KnowledgeFlowFrame = new JFrame("Weka KnowledgeFlow Environment");
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().add((Component)knowledgeFlowApp, "Center");
                    GUIChooser.this.m_KnowledgeFlowFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            knowledgeFlowApp.clearLayout();
                            GUIChooser.this.m_KnowledgeFlowFrame.dispose();
                            GUIChooser.this.m_KnowledgeFlowFrame = null;
                            GUIChooser.this.m_KnowledgeFlowBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_KnowledgeFlowFrame.pack();
                    GUIChooser.this.m_KnowledgeFlowFrame.setSize(900, 600);
                    GUIChooser.this.m_KnowledgeFlowFrame.setVisible(true);
                }
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.startApp();
            }
        });
        this.m_ArffViewerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArffViewer arffViewer = new ArffViewer();
                arffViewer.setVisible(true);
                GUIChooser.this.m_ArffViewers.add(arffViewer);
            }
        });
        this.m_LogWindowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                m_LogWindow.setVisible(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.pack();
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_SimpleCLI == null && this.m_ExplorerFrame == null && this.m_ExperimenterFrame == null && this.m_KnowledgeFlowFrame == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            m_chooser = new GUIChooser();
            m_chooser.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                9.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_chooser.dispose();
                                if (m_chooser.m_ExperimenterFrame != null) {
                                    m_chooser.m_ExperimenterFrame.dispose();
                                    m_chooser.m_ExperimenterFrame = null;
                                }
                                if (m_chooser.m_ExplorerFrame != null) {
                                    m_chooser.m_ExplorerFrame.dispose();
                                    m_chooser.m_ExplorerFrame = null;
                                }
                                if (m_chooser.m_KnowledgeFlowFrame != null) {
                                    m_chooser.m_KnowledgeFlowFrame.dispose();
                                    m_chooser.m_KnowledgeFlowFrame = null;
                                }
                                if (m_chooser.m_SimpleCLI != null) {
                                    m_chooser.m_SimpleCLI.dispose();
                                    m_chooser.m_SimpleCLI = null;
                                }
                                if (m_chooser.m_ArffViewers.size() > 0) {
                                    for (int i = 0; i < m_chooser.m_ArffViewers.size(); ++i) {
                                        ArffViewer arffViewer = (ArffViewer)m_chooser.m_ArffViewers.get(i);
                                        arffViewer.dispose();
                                    }
                                    m_chooser.m_ArffViewers.clear();
                                }
                                m_chooser = null;
                                System.gc();
                                m_Memory.stopThreads();
                                m_chooser;
                                m_LogWindow.setVisible(true);
                                m_chooser;
                                m_LogWindow.toFront();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting...");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }
}

