/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.zip.Adler32;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleModelMismatchException;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class EnsembleSelectionLibraryModel
extends EnsembleLibraryModel
implements Serializable {
    private static final long serialVersionUID = -6426075459862947640L;
    public static final String FILE_EXTENSION = ".elm";
    private Classifier[] m_models = null;
    private int m_seed;
    private String m_checksum;
    private double m_validationRatio;
    private int m_folds;
    private String m_fileName;
    public transient boolean m_Debug = true;
    private double[][] m_validationPredictions = null;

    public EnsembleSelectionLibraryModel() {
    }

    public EnsembleSelectionLibraryModel(Classifier classifier, int n, String string, double d, int n2) {
        super(classifier);
        this.m_seed = n;
        this.m_checksum = string;
        this.m_validationRatio = d;
        this.m_models = null;
        this.m_folds = n2;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public double[] getAveragePrediction(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_folds; ++i) {
            Instance instance2 = (Instance)instance.copy();
            double[] dArray2 = this.getFoldPrediction(instance2, i);
            if (dArray2 == null) {
                System.err.println("Null validation predictions given: " + this.getStringRepresentation());
                return null;
            }
            if (i == 0) {
                dArray = dArray2;
                continue;
            }
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNominal()) {
            Utils.normalize(dArray);
        } else {
            dArray[0] = dArray[0] / (double)this.m_folds;
        }
        return dArray;
    }

    public EnsembleSelectionLibraryModel(Classifier classifier) {
        super(classifier);
    }

    public double[] getFoldPrediction(Instance instance, int n) throws Exception {
        return this.m_models[n].distributionForInstance(instance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createModel(Instances[] instancesArray, Instances[] instancesArray2, String string, int n) throws Exception {
        String string2 = EnsembleSelectionLibraryModel.getFileName(this.getStringRepresentation());
        File file = new File(string, string2);
        String string3 = new File(string).getName() + File.separatorChar + string2;
        this.setFileName(string3);
        if (!file.exists()) {
            Date date = new Date();
            String string4 = EnsembleSelectionLibraryModel.getFileName(this.getStringRepresentation());
            File file2 = new File(string, string4 = string4.substring(0, string4.length() - 3) + "LCK");
            if (file2.exists()) {
                if (!this.m_Debug) throw new Exception("Lock File Detected: " + file2.getName());
                System.out.println("Detected lock file.  Skipping: " + string4);
                throw new Exception("Lock File Detected: " + file2.getName());
            }
            if (file2.createNewFile()) {
                int n2;
                int n3;
                if (this.m_Debug) {
                    System.out.println("lock file created: " + string4);
                }
                if (this.m_Debug) {
                    System.out.println("Creating model in locked mode: " + file.getPath());
                }
                this.m_models = new Classifier[this.m_folds];
                for (n3 = 0; n3 < this.m_folds; ++n3) {
                    try {
                        this.m_models[n3] = Classifier.forName(this.getModelClass().getName(), null);
                        this.m_models[n3].setOptions(this.getOptions());
                        continue;
                    }
                    catch (Exception exception) {
                        throw new Exception("Invalid Options: " + exception.getMessage());
                    }
                }
                try {
                    for (n3 = 0; n3 < this.m_folds; ++n3) {
                        this.train(instancesArray[n3], n3);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Could not Train: " + exception.getMessage());
                }
                Date date2 = new Date();
                int n4 = (int)(date2.getTime() - date.getTime());
                if (this.m_Debug) {
                    System.out.println("Train time for " + string2 + " was: " + n4);
                }
                if (this.m_Debug) {
                    System.out.println("Generating validation set predictions");
                }
                date = new Date();
                int n5 = 0;
                for (n2 = 0; n2 < this.m_folds; ++n2) {
                    n5 += instancesArray2[n2].numInstances();
                }
                this.m_validationPredictions = new double[n5][];
                n2 = 0;
                for (int i = 0; i < this.m_folds; ++i) {
                    for (int j = 0; j < instancesArray2[i].numInstances(); ++j) {
                        Instance instance = (Instance)instancesArray2[i].instance(j).copy();
                        this.m_validationPredictions[n2] = this.getFoldPrediction(instance, i);
                        if (this.m_validationPredictions[n2] == null) {
                            throw new Exception("Null validation predictions given: " + this.getStringRepresentation());
                        }
                        ++n2;
                    }
                }
                date2 = new Date();
                n4 = (int)(date2.getTime() - date.getTime());
                if (this.m_Debug) {
                    System.out.println("Time to create validation predictions was: " + n4);
                }
                EnsembleSelectionLibraryModel.saveModel(string, this);
                if (this.m_Debug) {
                    System.out.println("deleting lock file: " + string4);
                }
                file2.delete();
                return;
            }
            if (!this.m_Debug) throw new Exception("Could not create lock file.  Skipping: " + file2.getName());
            System.out.println("Could not create lock file.  Skipping: " + string4);
            throw new Exception("Could not create lock file.  Skipping: " + file2.getName());
        }
        if (this.m_Debug) {
            System.out.println("Loading model: " + file.getPath());
        }
        Date date = new Date();
        EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = EnsembleSelectionLibraryModel.loadModel(file.getPath());
        if (!ensembleSelectionLibraryModel.getStringRepresentation().equals(this.getStringRepresentation())) {
            throw new EnsembleModelMismatchException("String representations " + ensembleSelectionLibraryModel.getStringRepresentation() + " and " + this.getStringRepresentation() + " not equal");
        }
        if (!ensembleSelectionLibraryModel.getChecksum().equals(this.getChecksum())) {
            throw new EnsembleModelMismatchException("Checksums " + ensembleSelectionLibraryModel.getChecksum() + " and " + this.getChecksum() + " not equal");
        }
        if (ensembleSelectionLibraryModel.getSeed() != this.getSeed()) {
            throw new EnsembleModelMismatchException("Seeds " + ensembleSelectionLibraryModel.getSeed() + " and " + this.getSeed() + " not equal");
        }
        if (ensembleSelectionLibraryModel.getFolds() != this.getFolds()) {
            throw new EnsembleModelMismatchException("Folds " + ensembleSelectionLibraryModel.getFolds() + " and " + this.getFolds() + " not equal");
        }
        if (ensembleSelectionLibraryModel.getValidationRatio() != this.getValidationRatio()) {
            throw new EnsembleModelMismatchException("Validation Ratios " + ensembleSelectionLibraryModel.getValidationRatio() + " and " + this.getValidationRatio() + " not equal");
        }
        this.m_models = ensembleSelectionLibraryModel.getModels();
        this.m_validationPredictions = ensembleSelectionLibraryModel.getValidationPredictions();
        Date date3 = new Date();
        int n6 = (int)(date3.getTime() - date.getTime());
        if (!this.m_Debug) return;
        System.out.println("Time to load " + string2 + " was: " + n6);
    }

    public void rehydrateModel(String string) {
        if (this.m_models == null) {
            File file = new File(string, this.m_fileName);
            if (this.m_Debug) {
                System.out.println("Rehydrating Model: " + file.getPath());
            }
            EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = EnsembleSelectionLibraryModel.loadModel(file.getPath());
            this.m_models = ensembleSelectionLibraryModel.getModels();
        }
    }

    public void releaseModel() {
        this.m_models = null;
    }

    public void train(Instances instances, int n) throws Exception {
        if (this.m_models != null) {
            try {
                this.m_models[n].buildClassifier(instances);
            }
            catch (Throwable throwable) {
                this.m_models[n] = null;
                throw new Exception("Exception caught while training: (null could mean out of memory)" + throwable.getMessage());
            }
        } else {
            throw new Exception("Cannot train: model was null");
        }
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public void setValidationRatio(double d) {
        this.m_validationRatio = d;
    }

    public double getValidationRatio() {
        return this.m_validationRatio;
    }

    public void setFolds(int n) {
        this.m_folds = n;
    }

    public int getFolds() {
        return this.m_folds;
    }

    public void setChecksum(String string) {
        this.m_checksum = string;
    }

    public String getChecksum() {
        return this.m_checksum;
    }

    public Classifier[] getModels() {
        return this.m_models;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
    }

    public static String getStringChecksum(String string) {
        String string2 = null;
        try {
            Adler32 adler32 = new Adler32();
            byte[] byArray = string.toString().getBytes("UTF8");
            adler32.update(byArray);
            string2 = Long.toHexString(adler32.getValue());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getFileName(String string) {
        String string2 = string.trim().replace(' ', '_').replace('\"', '_');
        if (string2.length() > 115) {
            string2 = string2.substring(0, 115);
        }
        string2 = string2 + EnsembleSelectionLibraryModel.getStringChecksum(string) + FILE_EXTENSION;
        return string2;
    }

    public static void saveModel(String string, EnsembleSelectionLibraryModel ensembleSelectionLibraryModel) {
        try {
            String string2 = EnsembleSelectionLibraryModel.getFileName(ensembleSelectionLibraryModel.getStringRepresentation());
            File file = new File(string, string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(ensembleSelectionLibraryModel);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static EnsembleSelectionLibraryModel loadModel(String string) {
        EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = null;
        try {
            File file = new File(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            ensembleSelectionLibraryModel = (EnsembleSelectionLibraryModel)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ensembleSelectionLibraryModel;
    }

    public double[][] getValidationPredictions() {
        return this.m_validationPredictions;
    }

    public void setValidationPredictions(double[][] dArray) {
        if (this.m_Debug) {
            System.out.println("Saving validation array of size " + dArray.length);
        }
        this.m_validationPredictions = new double[dArray.length][];
        System.arraycopy(dArray, 0, this.m_validationPredictions, 0, dArray.length);
    }
}

