/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.CARuleMiner;
import weka.associations.CaRuleGeneration;
import weka.associations.ItemSet;
import weka.associations.LabeledItemSet;
import weka.associations.PriorEstimation;
import weka.associations.RuleGeneration;
import weka.associations.RuleItem;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class PredictiveApriori
extends AbstractAssociator
implements OptionHandler,
CARuleMiner,
TechnicalInformationHandler {
    static final long serialVersionUID = 8109088846865075341L;
    protected int m_premiseCount;
    protected int m_numRules;
    protected static final int m_numRandRules = 1000;
    protected static final int m_numIntervals = 100;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected Hashtable m_priors;
    protected double[] m_midPoints;
    protected double m_expectation;
    protected TreeSet m_best;
    protected boolean m_bestChanged;
    protected int m_count;
    protected PriorEstimation m_priorEstimator;
    protected int m_classIndex;
    protected boolean m_car;

    public String globalInfo() {
        return "Class implementing the predictive apriori algorithm to mine association rules.\nIt searches with an increasing support threshold for the best 'n' rules concerning a support-based corrected confidence value.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "The implementation follows the paper expect for adding a rule to the " + "output of the 'n' best rules. A rule is added if:\n" + "the expected predictive accuracy of this rule is among the 'n' best " + "and it is not subsumed by a rule with at least the same expected " + "predictive accuracy (out of an unpublished manuscript from T. " + "Scheffer).";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Tobias Scheffer");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Finding Association Rules That Trade Support Optimally against Confidence");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "5th European Conference on Principles of Data Mining and Knowledge Discovery");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "424-435");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public PredictiveApriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_numRules = 105;
        this.m_premiseCount = 1;
        this.m_best = new TreeSet();
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.m_car = false;
        this.m_classIndex = -1;
        this.m_priors = new Hashtable();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildAssociations(Instances instances) throws Exception {
        int n;
        int n2 = this.m_premiseCount;
        int n3 = this.m_numRules - 5;
        this.m_premiseCount = 1;
        this.m_best = new TreeSet();
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.m_instances = new Instances(instances);
        if (this.m_classIndex == -1) {
            this.m_instances.setClassIndex(this.m_instances.numAttributes() - 1);
        } else if (this.m_classIndex < this.m_instances.numAttributes() && this.m_classIndex >= 0) {
            this.m_instances.setClassIndex(this.m_classIndex);
        } else {
            throw new Exception("Invalid class index.");
        }
        this.getCapabilities().testWithFail(this.m_instances);
        this.m_priorEstimator = new PriorEstimation(this.m_instances, 1000, 100, this.m_car);
        this.m_priors = this.m_priorEstimator.estimatePrior();
        this.m_midPoints = this.m_priorEstimator.getMidPoints();
        this.m_Ls = new FastVector();
        this.m_hashtables = new FastVector();
        for (n = 1; n < this.m_instances.numAttributes(); ++n) {
            this.m_bestChanged = false;
            if (!this.m_car) {
                this.findLargeItemSets(n);
                this.findRulesQuickly();
            } else {
                this.findLargeCarItemSets(n);
                this.findCaRulesQuickly();
            }
            if (this.m_bestChanged) {
                n2 = this.m_premiseCount;
                while (RuleGeneration.expectation(this.m_premiseCount, this.m_premiseCount, this.m_midPoints, this.m_priors) <= this.m_expectation) {
                    ++this.m_premiseCount;
                    if (this.m_premiseCount <= this.m_instances.numInstances()) continue;
                }
            }
            if (this.m_premiseCount > this.m_instances.numInstances()) {
                this.m_allTheRules = new FastVector[3];
                this.m_allTheRules[0] = new FastVector();
                this.m_allTheRules[1] = new FastVector();
                this.m_allTheRules[2] = new FastVector();
                int n4 = 0;
                while (this.m_best.size() > 0 && n3 > 0) {
                    this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), n4);
                    this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), n4);
                    this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), n4);
                    this.m_best.remove(this.m_best.last());
                    ++n4;
                    --n3;
                }
                return;
            }
            if (n2 == this.m_premiseCount || this.m_Ls.size() <= 0) continue;
            FastVector fastVector = (FastVector)this.m_Ls.lastElement();
            this.m_Ls.removeElementAt(this.m_Ls.size() - 1);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            this.m_Ls.addElement(fastVector);
        }
        this.m_allTheRules = new FastVector[3];
        this.m_allTheRules[0] = new FastVector();
        this.m_allTheRules[1] = new FastVector();
        this.m_allTheRules[2] = new FastVector();
        n = 0;
        while (this.m_best.size() > 0 && n3 > 0) {
            this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), n);
            this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), n);
            this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), n);
            this.m_best.remove(this.m_best.last());
            ++n;
            --n3;
        }
    }

    public FastVector[] mineCARs(Instances instances) throws Exception {
        this.m_car = true;
        this.m_best = new TreeSet();
        this.m_premiseCount = 1;
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.buildAssociations(instances);
        FastVector[] fastVectorArray = new FastVector[]{new FastVector(), new FastVector(), new FastVector()};
        for (int i = 0; i < this.m_allTheRules[0].size(); ++i) {
            int[] nArray = new int[this.m_instances.numAttributes() - 1];
            int n = 0;
            for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                if (j == this.m_instances.classIndex()) continue;
                nArray[n] = ((ItemSet)this.m_allTheRules[0].elementAt(i)).itemAt(j);
                ++n;
            }
            ItemSet itemSet = new ItemSet(this.m_instances.numInstances(), nArray);
            itemSet.setCounter(((ItemSet)this.m_allTheRules[0].elementAt(i)).counter());
            fastVectorArray[0].addElement(itemSet);
            int[] nArray2 = new int[]{((ItemSet)this.m_allTheRules[1].elementAt(i)).itemAt(this.m_instances.classIndex())};
            ItemSet itemSet2 = new ItemSet(this.m_instances.numInstances(), nArray2);
            itemSet2.setCounter(((ItemSet)this.m_allTheRules[1].elementAt(i)).counter());
            fastVectorArray[1].addElement(itemSet2);
            fastVectorArray[2].addElement(this.m_allTheRules[2].elementAt(i));
        }
        return fastVectorArray;
    }

    public Instances getInstancesNoClass() {
        Instances instances = null;
        try {
            instances = LabeledItemSet.divide(this.m_instances, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage());
        }
        return instances;
    }

    public Instances getInstancesOnlyClass() {
        Instances instances = null;
        try {
            instances = LabeledItemSet.divide(this.m_instances, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage());
        }
        return instances;
    }

    public Enumeration listOptions() {
        String string = "\tThe required number of rules. (default = " + (this.m_numRules - 5) + ")";
        String string2 = "\tIf set class association rules are mined. (default = no)";
        String string3 = "\tThe class index. (default = last)";
        FastVector fastVector = new FastVector(3);
        fastVector.addElement(new Option(string, "N", 1, "-N <required number of rules output>"));
        fastVector.addElement(new Option(string2, "A", 0, "-A"));
        fastVector.addElement(new Option(string3, "c", 1, "-c <the class index>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('N', stringArray);
        this.m_numRules = string.length() != 0 ? Integer.parseInt(string) + 5 : Integer.MAX_VALUE;
        String string2 = Utils.getOption('c', stringArray);
        if (string2.length() != 0) {
            this.m_classIndex = Integer.parseInt(string2);
        }
        this.m_car = Utils.getFlag('A', stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-N");
        vector.add("" + (this.m_numRules - 5));
        if (this.m_car) {
            vector.add("-A");
        }
        vector.add("-c");
        vector.add("" + this.m_classIndex);
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_allTheRules[0].size() == 0) {
            return "\nNo large itemsets and rules found!\n";
        }
        stringBuffer.append("\nPredictiveApriori\n===================\n\n");
        stringBuffer.append("\nBest rules found:\n\n");
        for (int i = 0; i < this.m_allTheRules[0].size(); ++i) {
            stringBuffer.append(Utils.doubleToString((double)i + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((ItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances) + " ==> " + ((ItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_instances) + "    acc:(" + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(i), 5) + ")");
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules - 5;
    }

    public void setNumRules(int n) {
        this.m_numRules = n + 5;
    }

    public void setClassIndex(int n) {
        this.m_classIndex = n;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public String classIndexTipText() {
        return "Index of the class attribute.\n If set to -1, the last attribute will be taken as the class attribute.";
    }

    public void setCar(boolean bl) {
        this.m_car = bl;
    }

    public boolean getCar() {
        return this.m_car;
    }

    public String carTipText() {
        return "If enabled class association rules are mined instead of (general) association rules.";
    }

    public String metricString() {
        return "acc";
    }

    private void findLargeItemSets(int n) throws Exception {
        FastVector fastVector = new FastVector();
        int n2 = 0;
        if (n == 1) {
            fastVector = ItemSet.singletons(this.m_instances);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
        if (n > 1) {
            if (this.m_Ls.size() > 0) {
                fastVector = (FastVector)this.m_Ls.lastElement();
            }
            this.m_Ls.removeAllElements();
            n2 = n - 2;
            FastVector fastVector2 = fastVector;
            fastVector = ItemSet.mergeAllItemSets(fastVector2, n2, this.m_instances.numInstances());
            Hashtable hashtable = ItemSet.getHashtable(fastVector2, fastVector2.size());
            this.m_hashtables.addElement(hashtable);
            fastVector = ItemSet.pruneItemSets(fastVector, hashtable);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int i = 0; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                RuleGeneration ruleGeneration = new RuleGeneration((ItemSet)enumeration.nextElement());
                this.m_best = ruleGeneration.generateRules(this.m_numRules - 5, this.m_midPoints, this.m_priors, this.m_expectation, this.m_instances, this.m_best, this.m_count);
                this.m_count = ruleGeneration.m_count;
                if (!this.m_bestChanged && ruleGeneration.m_change) {
                    this.m_bestChanged = true;
                }
                if (this.m_best.size() >= this.m_numRules - 5) {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    continue;
                }
                this.m_expectation = 0.0;
            }
        }
    }

    private void findLargeCarItemSets(int n) throws Exception {
        FastVector fastVector = new FastVector();
        int n2 = 0;
        if (n == 1) {
            fastVector = CaRuleGeneration.singletons(this.m_instances);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
        if (n > 1) {
            if (this.m_Ls.size() > 0) {
                fastVector = (FastVector)this.m_Ls.lastElement();
            }
            this.m_Ls.removeAllElements();
            n2 = n - 2;
            FastVector fastVector2 = fastVector;
            fastVector = ItemSet.mergeAllItemSets(fastVector2, n2, this.m_instances.numInstances());
            Hashtable hashtable = ItemSet.getHashtable(fastVector2, fastVector2.size());
            this.m_hashtables.addElement(hashtable);
            fastVector = ItemSet.pruneItemSets(fastVector, hashtable);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
    }

    private void findCaRulesQuickly() throws Exception {
        for (int i = 0; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                CaRuleGeneration caRuleGeneration = new CaRuleGeneration((ItemSet)enumeration.nextElement());
                this.m_best = caRuleGeneration.generateRules(this.m_numRules - 5, this.m_midPoints, this.m_priors, this.m_expectation, this.m_instances, this.m_best, this.m_count);
                this.m_count = caRuleGeneration.count();
                if (!this.m_bestChanged && caRuleGeneration.change()) {
                    this.m_bestChanged = true;
                }
                if (this.m_best.size() == this.m_numRules - 5) {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    continue;
                }
                this.m_expectation = 0.0;
            }
        }
    }

    public FastVector[] getAllTheRules() {
        return this.m_allTheRules;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.14 $");
    }

    public static void main(String[] stringArray) {
        PredictiveApriori.runAssociator(new PredictiveApriori(), stringArray);
    }
}

